DELIMITER $$
DROP PROCEDURE IF EXISTS V20251226173350__Create_assessmentSchedulesHistory $$
CREATE PROCEDURE V20251226173350__Create_assessmentSchedulesHistory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='assessment_schedules_history')) THEN 
CREATE TABLE `assessment_schedules_history` (
   `id` BIGINT NOT NULL,
  `REV` BIGINT NOT NULL,
  `REVTYPE` TINYINT DEFAULT NULL,
  `academyLocationId` BIGINT NOT NULL,
  `academicTermId` BIGINT NOT NULL,
  `eventId` BIGINT DEFAULT NULL,
  `programId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL ,
  `courseId` BIGINT NOT NULL,
  `subTypeId` BIGINT DEFAULT NULL,
  `academicTermCode` VARCHAR(255) DEFAULT NULL,
  `programCode` VARCHAR(255) DEFAULT NULL,
  `qualificationFaculty` VARCHAR(255) DEFAULT NULL,
  `batchName` VARCHAR(255) DEFAULT NULL,
  `periodName` VARCHAR(255) DEFAULT NULL,
  `courseCode` VARCHAR(255) DEFAULT NULL,
  `courseName` VARCHAR(255) DEFAULT NULL,
  `camsQualCode` VARCHAR(255) DEFAULT NULL,
  `camsProgramCode` VARCHAR(255) DEFAULT NULL,
  `camsModuleCode` VARCHAR(255) DEFAULT NULL,
  `subTypeName` VARCHAR(255) DEFAULT NULL,
  `nqfLevel` VARCHAR(255) DEFAULT NULL,
  `brandCode` VARCHAR(255) DEFAULT NULL,
  `campus` VARCHAR(255) DEFAULT NULL,
  `modeOfDelivery` VARCHAR(255) DEFAULT NULL, 
  `templateName` VARCHAR(255) DEFAULT NULL,          
  `periodStartDate` datetime DEFAULT NULL,
  `periodEndDate` datetime DEFAULT NULL,
  `moduleCredits` FLOAT DEFAULT NULL,
  `weighting` FLOAT DEFAULT NULL,
  `totalPoints` FLOAT DEFAULT NULL,
  `duration` FLOAT DEFAULT NULL,
  `status` TINYINT(1) NULL DEFAULT 0,
  `yearModule` TINYINT(1) NULL DEFAULT 0,
  `ilmsModule` TINYINT(1) NULL DEFAULT 0, 
  `eventName` VARCHAR(255) DEFAULT NULL, 
  `date` DATE DEFAULT NULL,
  `time` TIME DEFAULT NULL,
  `venueCode` VARCHAR(255) DEFAULT NULL, 
  `invigilator` VARCHAR(255) DEFAULT NULL, 
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`,`REV`)
  ) ENGINE=InnoDB;
END IF; 

END $$
CALL V20251226173350__Create_assessmentSchedulesHistory () $$ 
DROP PROCEDURE IF EXISTS V20251226173350__Create_assessmentSchedulesHistory $$ 
DELIMITER ;