DROP TABLE IF EXISTS bill_dependant_details;
CREATE TABLE `bill_dependant_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `billId` bigint(20) DEFAULT NULL,
  `dependantBillTypeId` bigint(20) DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `dependantHeadId` bigint(20) DEFAULT NULL,
  `refBillId` bigint(20) DEFAULT NULL,
  `raiseBillCategory` varchar(150) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refuser3432_idx` (`dependantBillTypeId`),
  KEY `Reffeehead36546_idx` (`dependantHeadId`),
  KEY `Refuser768_idx` (`lastUpdatedBy`),
  KEY `Refbillheader5464_idx` (`billId`),
  KEY `Refbillheader679_idx` (`refBillId`),
  CONSTRAINT `Refbillheader5464` FOREIGN KEY (`billId`) REFERENCES `bill_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refbillheader679` FOREIGN KEY (`refBillId`) REFERENCES `bill_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refdependantbilltype3432` FOREIGN KEY (`dependantBillTypeId`) REFERENCES `dependent_bill_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffeehead36546` FOREIGN KEY (`dependantHeadId`) REFERENCES `fee_heads` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refuser768` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS bill_service_received;
CREATE TABLE `bill_service_received` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `billId` bigint(20) DEFAULT NULL,
  `serviceReceived` bigint(20) DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refuser4343_idx` (`lastUpdatedBy`),
  KEY `RefServicereceived_idx` (`serviceReceived`),
  KEY `Refbillheader3442_idx` (`billId`),
  CONSTRAINT `Refbillheader3442` FOREIGN KEY (`billId`) REFERENCES `bill_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefServicereceived` FOREIGN KEY (`serviceReceived`) REFERENCES `service_received` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refuser4343` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `bill_service_received` 
ADD COLUMN `noOfSession` BIGINT(20) NULL AFTER `feeAmount`;
