CREATE TABLE user_mapping(
	id BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
	academiaUserId BIGINT(20),
	clientUserId VARCHAR(255),
	lastUpdatedBy BIGINT(20),
	lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	FOREIGN KEY (academiaUserId) REFERENCES users(id),
	FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
);

CREATE TABLE attendance_machine_user(
	id BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
	attendanceMachineId BIGINT(20),
	userMappingId BIGINT(20),
	lastUpdatedBy BIGINT(20),
	lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	FOREIGN KEY (attendanceMachineId) REFERENCES attendance_machine(id),
	FOREIGN KEY (lastUpdatedBy) REFERENCES users(id),
	FOREIGN KEY (userMappingId) REFERENCES user_mapping(id)
);

ALTER TABLE `attendance_machine_log` 
DROP FOREIGN KEY `attendance_machine_log_ibfk_2`,
DROP FOREIGN KEY `attendance_machine_log_ibfk_1`;

ALTER TABLE `attendance_machine_log` 
DROP COLUMN `userId`,
DROP COLUMN `attendanceMachineLocationId`,
DROP INDEX `userId` ,
DROP INDEX `attendanceMachineLocationId` ;

ALTER TABLE attendance_machine_log
ADD COLUMN attendanceMachineUserId BIGINT(20),
ADD FOREIGN KEY (attendanceMachineUserId) REFERENCES attendance_machine_user(id)
;