CREATE TABLE `trans_user_attendance` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `journeyAssignmentId` BIGINT(20) NULL DEFAULT NULL,
  `serviceRouteUserId` BIGINT(20) NULL DEFAULT NULL,
  `attendance` VARCHAR(45) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_trans_user_attendance_1_idx` (`serviceRouteUserId` ASC),
  INDEX `fk_trans_user_attendance_2_idx` (`journeyAssignmentId` ASC),
  INDEX `fk_trans_user_attendance_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_trans_user_attendance_1`
    FOREIGN KEY (`serviceRouteUserId`)
    REFERENCES `trans_service_route_users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_trans_user_attendance_2`
    FOREIGN KEY (`journeyAssignmentId`)
    REFERENCES `trans_journey_assignment` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_trans_user_attendance_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT) ENGINE=InnoDB DEFAULT CHARSET=utf8;