
CREATE TABLE `attendance_academy_location` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(255) NULL DEFAULT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_attendance_academylocationIdref001_idx` (`academyLocationId` ASC),
  CONSTRAINT `fk_attendance_academylocationIdref001`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);



SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`, `tableName`, `masterName`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@standardMasterMaxId+1, 'attendance_academy_location', 'ATTENDANCE_ACADEMY_LOCATION', 0, 0, '1',@currentTimeStamp);


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ACADEMY_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',@currentTimeStamp);

INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@ItemsMaxId+2, 'academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId+1, 'Varchar', '2', 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, '1',@currentTimeStamp);


CREATE TABLE `key_value_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(255) NULL DEFAULT NULL,
  `value` BIGINT(13) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`));
  
  
  