CREATE TABLE `dashlets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `displayCode` varchar(255) NOT NULL,
  `category` varchar(255) DEFAULT NULL,
  `xtype` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `dashlets_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


CREATE TABLE `dashlets_portals` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `dashletId` bigint(20) NOT NULL,
  `portalId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_dashlets_portals_1` (`portalId`),
  KEY `fk_dashlets_portals_2` (`dashletId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `dashlets_portals_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_dashlets_portals_1` FOREIGN KEY (`portalId`) REFERENCES `portals` (`id`),
  CONSTRAINT `fk_dashlets_portals_2` FOREIGN KEY (`dashletId`) REFERENCES `dashlets` (`id`)
);


CREATE TABLE `role_portal_dashlets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `roleId` bigint(20) NOT NULL,
  `portalId` bigint(20) NOT NULL,
  `dashletId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_role_portal_dashlets_1` (`portalId`),
  KEY `fk_role_portal_dashlets_2` (`dashletId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_role_portal_dashlets_1` FOREIGN KEY (`portalId`) REFERENCES `portals` (`id`),
  CONSTRAINT `fk_role_portal_dashlets_2` FOREIGN KEY (`dashletId`) REFERENCES `dashlets` (`id`),
  CONSTRAINT `role_portal_dashlets_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


CREATE TABLE `user_dashlets_pereferences` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) NOT NULL,
  `portalId` bigint(20) NOT NULL,
  `dashletId` bigint(20) NOT NULL,
  `height` int(11) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  `whetherCollapsed` bit(1) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_userDashletsPereferences_2` (`dashletId`),
  KEY `fk_userDashletsPereferences_1` (`userId`),
  KEY `fk_user_dashlets_pereferences_3` (`lastUpdatedBy`),
  KEY `fk_user_dashlets_pereferences_4` (`portalId`),
  CONSTRAINT `fk_userDashletsPereferences_1` FOREIGN KEY (`userId`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_userDashletsPereferences_2` FOREIGN KEY (`dashletId`) REFERENCES `dashlets` (`id`),
  CONSTRAINT `fk_user_dashlets_pereferences_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_user_dashlets_pereferences_4` FOREIGN KEY (`portalId`) REFERENCES `portals` (`id`)
);

CREATE TABLE `dashlets_user_override` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) NOT NULL,
  `portalId` bigint(20) NOT NULL,
  `dashletId` bigint(20) NOT NULL,
  `whetherAccessGranted` bit(1) NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `dashlets_user_override_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

