CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`%` 
    SQL SECURITY DEFINER
VIEW `evaluation_group_specific` AS
    select 
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `programBatchId`,
        `evaluation_group`.`id` AS `id`,
        `admission`.`id` AS `admissionId`,
        `admission`.`code` AS `admissionCode`,
        `users`.`printName` AS `printName`,
        `evaluation_group`.`evaluationGroupCode` AS `evaluationGroupCode`,
        sum(`eval_seq_detail`.`maxMarks`) AS `markObtainedFrom`,
        sum(`examination_result`.`finalMarks`) AS `markObtained`,
        avg(`examination_result`.`gradePoints`) AS `gradePoints`,
        `examination_result`.`finalGrade` AS `grade`,
        `examination_result`.`status` AS `status`,
        `evaluation_plan`.`id` AS `evaluationPlanId`,
        `prog_batch_period_config`.`id` AS `programBatchPeriodConfigId`
    from
        ((((((((((((((`examination_result`
        left join `eval_seq_detail` ON ((`examination_result`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        left join `evaluation_group` ON ((`examination_result`.`evaluationGroupId` = `evaluation_group`.`id`)))
        left join `admission` ON ((`examination_result`.`admissionId` = `admission`.`id`)))
        left join `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        left join `users` ON ((`students`.`userId` = `users`.`id`)))
        left join `batches` ON ((`admission`.`batchId` = `batches`.`id`)))
        left join `programs` ON ((`admission`.`programId` = `programs`.`id`)))
        left join `evaluation_sequence` ON ((`eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`)))
        left join `evaluation_plan_level_two` ON ((`evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`)))
        left join `evaluation_plan_level_one` ON ((`evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`)))
        left join `evaluation_plan` ON ((`evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`)))
        left join `evaluation_type_course` ON ((`evaluation_type_course`.`evaluationPlanId` = `evaluation_plan`.`id`)))
        left join `student_course_enrollment` ON (((`student_course_enrollment`.`admissionId` = `admission`.`id`)
            and (`evaluation_type_course`.`courseVariantId` = `student_course_enrollment`.`courseVarientId`))))
        left join `prog_batch_period_config` ON ((`student_course_enrollment`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
    where
        ((`examination_result`.`examResultStatus` = 'RESULT_ENTERED')
            and (`examination_result`.`evaluationGroupId` is not null))
    group by `evaluation_group`.`id` , `admission`.`id`;
    
    
    CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`%` 
    SQL SECURITY DEFINER
VIEW `evaluaton_group_course_specific` AS
    select 
        `examination_result`.`evaluationGroupId` AS `evaluationGroupId`,
        `admission`.`id` AS `admissionId`,
        `admission`.`code` AS `admissionCode`,
        `courses`.`courseName` AS `courseName`,
        `courses`.`id` AS `courseId`,
        `sections`.`sectionCode` AS `sectionCode`,
        `evaluation_plan`.`evaluationPlanNumber` AS `evaluationPlanNumber`,
        sum(`eval_seq_detail`.`maxMarks`) AS `markObtainedFrom`,
        sum(`examination_result`.`finalMarks`) AS `markObtained`,
        avg(`examination_result`.`gradePoints`) AS `gradePoints`,
        `examination_result`.`finalGrade` AS `grade`,
        `examination_result`.`status` AS `status`,
        `evaluation_plan`.`id` AS `evaluationPlanId`
    from
        ((((((((((`examination_result`
        left join `eval_seq_detail` ON ((`examination_result`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        left join `admission` ON ((`examination_result`.`admissionId` = `admission`.`id`)))
        left join `evaluation_sequence` ON ((`eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`)))
        left join `evaluation_plan_level_two` ON ((`evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`)))
        left join `evaluation_plan_level_one` ON ((`evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`)))
        left join `evaluation_plan` ON ((`evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`)))
        left join `courses` ON ((`evaluation_plan`.`courseId` = `courses`.`id`)))
        left join `evaluation_type_course` ON ((`evaluation_plan`.`id` = `evaluation_type_course`.`evaluationPlanId`)))
        left join `student_course_enrollment` ON (((`admission`.`id` = `student_course_enrollment`.`admissionId`)
            and (`evaluation_type_course`.`courseVariantId` = `student_course_enrollment`.`courseVarientId`))))
        left join `sections` ON ((`student_course_enrollment`.`sectionId` = `sections`.`id`)))
    where
        ((`examination_result`.`examResultStatus` = 'RESULT_ENTERED')
            and (`examination_result`.`evaluationGroupId` is not null))
    group by `courses`.`id` , `examination_result`.`evaluationGroupId` , `admission`.`id`;

