CREATE TABLE `person_research_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personId` bigint(20) NOT NULL,
  `researchTypeId` bigint(20) DEFAULT NULL,
  `researchTitle` varchar(255) DEFAULT NULL,
  `researchDate` date DEFAULT NULL,
  `isbnNumber` varchar(255) DEFAULT NULL,
  `authorName` varchar(255) DEFAULT NULL,
  `otherAuthorName` varchar(500) DEFAULT NULL,
  `pageNumber` int(5) DEFAULT NULL,
  `volumeNo` varchar(255) DEFAULT NULL,
  `issueNo` varchar(255) DEFAULT NULL,
  `impactFactor` varchar(255) DEFAULT NULL,
  `publicationYearId` bigint(20) DEFAULT NULL,
  `journalTypeId` bigint(20) DEFAULT NULL,
  `journalName` varchar(255) DEFAULT NULL,
  `publisherName` varchar(255) DEFAULT NULL,
  `researchGroup` varchar(255) DEFAULT NULL,
  `url` varchar(500) DEFAULT NULL,
  `projectType` varchar(255) DEFAULT NULL,
  `amountGranted` double(10,2) DEFAULT NULL,
  `fundingAgencyName` varchar(255) DEFAULT NULL,
  `fundType` varchar(255) DEFAULT NULL,
  `tenure` varchar(255) DEFAULT NULL,
  `whetherInstituteAffiliation` bit(1) DEFAULT NULL,
  `whetherUCSubmitted` bit(1) DEFAULT NULL,
  `dateOfUCSubmission` date DEFAULT NULL,
  `researchDetails` text,
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_Person_idx` (`personId`),
  KEY `FK_Research_Type_idx` (`researchTypeId`),
  KEY `FK_UpdatedBy_idx` (`lastUpdatedBy`),
  KEY `FK_PublicationYear_idx` (`publicationYearId`),
  KEY `FK_ConferenceType_idx` (`journalTypeId`),
  CONSTRAINT `FK_ConferenceType` FOREIGN KEY (`journalTypeId`) REFERENCES `conference_journal_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_Person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PublicationYear` FOREIGN KEY (`publicationYearId`) REFERENCES `publication_year` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_Research_Type` FOREIGN KEY (`researchTypeId`) REFERENCES `research_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_UpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_research_publication_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personResearchId` bigint(20) NOT NULL,
  `publicationIndexId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonResearch_idx` (`personResearchId`),
  KEY `FK_PublicationIndex_idx` (`publicationIndexId`),
  KEY `FK_LastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_LastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PersonResearch` FOREIGN KEY (`personResearchId`) REFERENCES `person_research_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PublicationIndex` FOREIGN KEY (`publicationIndexId`) REFERENCES `publication_index` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `person_research_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `personResearchId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonResearch121_idx` (`personResearchId`),
  KEY `FK_DoucmentUpBY142_idx` (`lastUpdatedBy`),
  KEY `FK_ResearchDocument_idx` (`documentId`),
  CONSTRAINT `FK_DoucmentUpBY142` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PersonResearch121` FOREIGN KEY (`personResearchId`) REFERENCES `person_research_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_ResearchDocument` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `person_seminar_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personId` bigint(20) NOT NULL,
  `seminarTypeId` bigint(20) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `numberOfDays` int(5) DEFAULT NULL,
  `placeOfSeminar` varchar(255) DEFAULT NULL,
  `organizedBy` varchar(255) DEFAULT NULL,
  `conferenceType` varchar(255) DEFAULT NULL,
  `url` varchar(500) DEFAULT NULL,
  `otherDetails` text,
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonSeminar_idx` (`personId`),
  KEY `FK_SeminarUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `FK_SeminarType_idx` (`seminarTypeId`),
  CONSTRAINT `FK_PersonSeminar` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_SeminarType` FOREIGN KEY (`seminarTypeId`) REFERENCES `seminar_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_SeminarUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_seminar_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `personSeminarId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonSeminar101_idx` (`personSeminarId`),
  KEY `FK_SeminarDocument101_idx` (`documentId`),
  KEY `FK_SeminarDocumentUpBy101_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_PersonSeminar101` FOREIGN KEY (`personSeminarId`) REFERENCES `person_seminar_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_SeminarDocument101` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_SeminarDocumentUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_patent_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personId` bigint(20) NOT NULL,
  `patentType` varchar(255) DEFAULT NULL,
  `patentName` varchar(255) DEFAULT NULL,
  `dateOfPatentFiled` date DEFAULT NULL,
  `dateOfPatentAwarded` date DEFAULT NULL,
  `otherDetails` text,
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonPatent_idx` (`personId`),
  KEY `FK_PatentLastUpdateBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_PatentLastUpdateBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PersonPatent` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_patent_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `personPatentId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_Patent101_idx` (`personPatentId`),
  KEY `FK_PatentDocument12_idx` (`documentId`),
  KEY `FK_patentDocUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_Patent101` FOREIGN KEY (`personPatentId`) REFERENCES `person_patent_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PatentDocument12` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_patentDocUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_training_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personId` bigint(20) NOT NULL,
  `trainingTypeId` bigint(20) DEFAULT NULL,
  `trainingSpecialization` varchar(255) DEFAULT NULL,
  `organisationName` varchar(255) DEFAULT NULL,
  `trainingStatus` varchar(255) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_Person7854_idx` (`personId`),
  KEY `FK_TrainingType101_idx` (`trainingTypeId`),
  KEY `FK_TrainingUpBy101_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_Person7854` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_TrainingType101` FOREIGN KEY (`trainingTypeId`) REFERENCES `training_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_TrainingUpBy101` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_training_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `personTrainingId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonTraining101_idx` (`personTrainingId`),
  KEY `FK_TrainingDocument101_idx` (`documentId`),
  KEY `FK_TrainingDocUpBy101_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_PersonTraining101` FOREIGN KEY (`personTrainingId`) REFERENCES `person_training_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_TrainingDocUpBy101` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_TrainingDocument101` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `person_consultancy_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personId` bigint(20) NOT NULL,
  `clientName` varchar(255) DEFAULT NULL,
  `place` varchar(255) DEFAULT NULL,
  `amount` double(10,2) DEFAULT NULL,
  `consultancyDetails` text,
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_Person458_idx` (`personId`),
  KEY `FK_consultancyUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_Person458` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_consultancyUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `person_consultancy_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `personConsultancyId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_PersonConsultancy101_idx` (`personConsultancyId`),
  KEY `FK_ConsultancyDocument_idx` (`documentId`),
  KEY `FK_ConsultancyDocUpBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_ConsultancyDocUpBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_ConsultancyDocument` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_PersonConsultancy101` FOREIGN KEY (`personConsultancyId`) REFERENCES `person_consultancy_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

