CREATE 
   	OR REPLACE
VIEW `student_course_report` AS
    select 
        `student_course_enrollment`.`id` AS `studentCourseEnrollmentId`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        `course_variants`.`courseVariantCode` AS `courseVariantCode`,
        `student_course_enrollment`.`whetherOptional` AS `whetherOptional`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `student_course_enrollment`.`marksObtained`
            else ''
        end) AS `marksObtained`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `student_course_enrollment`.`whetherPassed`
        end) AS `whetherPassed`,
        (case
            when ((`student_course_enrollment`.`exitDate` is not null) and (`student_course_enrollment`.`isCurrentSection` = 1)) then "Yes"
          else "No"
            end) AS `withDrawl`,
        `marksheet_job_details`.`id` AS `marksJobDetailsId`,
        `marksheet_job_details`.`isPublishMarksheet` AS `isPublishMarksheet`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `admission`.`studentId` AS `studentId`,
        `prog_batch_period_config`.`id` AS `periodId`
    from
        (((((((`student_course_enrollment`
        left join `admission` ON ((`admission`.`id` = `student_course_enrollment`.`admissionId`)))
        left join `course_variants` ON ((`course_variants`.`id` = `student_course_enrollment`.`courseVarientId`)))
        left join `prog_batch_period_config` ON ((`prog_batch_period_config`.`id` = `student_course_enrollment`.`programBatchPeriodConfigId`)))
       
        left join `courses` ON ((`courses`.`id` = `course_variants`.`courseId`)))
        left join `marksheet_job_details` ON ((`marksheet_job_details`.`admissionId` = `admission`.`id`)))
        left join `programs` ON ((`programs`.`id` = `admission`.`programId`)))
        left join `batches` ON ((`batches`.`id` = `admission`.`batchId`)))
    group by `courses`.`id`, `admission`.`id`;