CREATE OR REPLACE VIEW `pnc_dashboard_delayed_course_cbs` AS 
(SELECT 
    ccp.academyLocationId AS academyLocationId,
    ccp.courseId AS courseId,
    ccp.sectionId AS sectionId,
    CONCAT(al.academyName, ' - ', al.locationName) AS AcademyLocation,
    c.courseName AS CourseName,
    cv.courseVariantCode AS CourseVariantCode,
    u.id AS facultyId,
    u.printName AS facultyName,
    COUNT(0) AS TotalSessions,
    COUNT((CASE
        WHEN (ccp.sessionDate <= SYSDATE()) THEN ccp.id
    END)) AS SessionTillDate,
    COUNT((CASE
        WHEN
            ((ccp.sessionDate <= SYSDATE())
                AND (fpa.facultyId IS NOT NULL)
                AND (fpa.attendanceStatus = 'PRESENT'))
        THEN
            fpa.facultyId
    END)) AS SesssionConductedTillDate,
    COUNT((CASE
        WHEN (ccp.sessionDate <= SYSDATE()) THEN ccp.id
    END)) - COUNT((CASE
        WHEN
            ((ccp.sessionDate <= SYSDATE())
                AND (fpa.facultyId IS NOT NULL)
                AND (fpa.attendanceStatus = 'PRESENT'))
        THEN
            fpa.facultyId
    END)) AS DueTillDate,
    ROUND((COUNT((CASE
                WHEN (ccp.sessionDate <= SYSDATE()) THEN ccp.id
            END)) - COUNT((CASE
                WHEN
                    ((ccp.sessionDate <= SYSDATE())
                        AND (fpa.facultyId IS NOT NULL)
                        AND (fpa.attendanceStatus = 'PRESENT'))
                THEN
                    fpa.facultyId
            END))) / COUNT(0) * 100,
            2) AS Deviation
FROM
    course_coverage_plan ccp
        LEFT JOIN
    academy_location al ON ccp.academyLocationId = al.id
        LEFT JOIN
    courses c ON ccp.courseId = c.id
        LEFT JOIN
    course_variants cv ON ccp.courseVariantId = cv.id
        LEFT JOIN
    users u ON ccp.facultyId = u.id
        LEFT JOIN
    attendance_academylocationwise_setup setting ON ccp.academyLocationId = setting.academyLocationId
        LEFT JOIN
    faculty_program_attendance fpa ON ccp.facultyId = fpa.facultyId
        AND ccp.sessionDate = fpa.dateOfAttendance
        AND ccp.academyLocationId = fpa.academyLocationId
WHERE
    c.assignSectionType = 'CourseSection'
        AND setting.facultyAttendanceType = 'COMPLETE_DAY'
GROUP BY ccp.courseVariantId) UNION (SELECT 
    ccp.academyLocationId AS academyLocationId,
    ccp.courseId AS courseId,
    ccp.sectionId AS sectionId,
    CONCAT(al.academyName, ' - ', al.locationName) AS AcademyLocation,
    c.courseName AS CourseName,
    cv.courseVariantCode AS CourseVariantCode,
    u.id AS facultyId,
    u.printName AS facultyName,
    COUNT(0) AS TotalSessions,
    COUNT((CASE
        WHEN (ccp.sessionDate <= SYSDATE()) THEN ccp.id
    END)) AS SessionTillDate,
    COUNT((CASE
        WHEN
            ((ccp.sessionDate <= SYSDATE())
                AND (fcad.facultyId IS NOT NULL)
                AND (fcad.attendanceStatus = 'PRESENT'))
        THEN
            fcad.facultyId
    END)) AS SesssionConductedTillDate,
    COUNT((CASE
        WHEN (ccp.sessionDate <= SYSDATE()) THEN ccp.id
    END)) - COUNT((CASE
        WHEN
            ((ccp.sessionDate <= SYSDATE())
                AND (fcad.facultyId IS NOT NULL)
                AND (fcad.attendanceStatus = 'PRESENT'))
        THEN
            fcad.facultyId
    END)) AS DueTillDate,
    ROUND((COUNT((CASE
                WHEN (ccp.sessionDate <= SYSDATE()) THEN ccp.id
            END)) - COUNT((CASE
                WHEN
                    ((ccp.sessionDate <= SYSDATE())
                        AND (fcad.facultyId IS NOT NULL)
                        AND (fcad.attendanceStatus = 'PRESENT'))
                THEN
                    fcad.facultyId
            END))) / COUNT(*) * 100,
            2) AS Deviation
FROM
    course_coverage_plan ccp
        LEFT JOIN
    academy_location al ON ccp.academyLocationId = al.id
        LEFT JOIN
    courses c ON ccp.courseId = c.id
        LEFT JOIN
    course_variants cv ON ccp.courseVariantId = cv.id
        LEFT JOIN
    users u ON ccp.facultyId = u.id
        LEFT JOIN
    attendance_academylocationwise_setup setting ON ccp.academyLocationId = setting.academyLocationId
        LEFT JOIN
    faculty_course_attendance fca ON ccp.academyLocationId = fca.academyLocationId
        AND ccp.sessionDate = fca.dateOfAttendance
        LEFT JOIN
    faculty_course_attendance_details fcad ON fca.id = fcad.attendanceId
        AND ccp.facultyId = fcad.facultyId
WHERE
    c.assignSectionType = 'CourseSection'
        AND setting.facultyAttendanceType = 'COURSE_LEVEL'
GROUP BY ccp.courseVariantId);
