ALTER TABLE `academy_location` 
ADD COLUMN `ownership` VARCHAR(45) NULL AFTER `path`;


CREATE TABLE `placement_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `placementType` varchar(255) NOT NULL,
  `whetherCompletion` bit(1) DEFAULT NULL,
  `placementTerm` varchar(45) DEFAULT NULL,
  `whetherGraded` bit(1) DEFAULT NULL,
  `gradeOrMark` varchar(45) DEFAULT NULL,
  `whetherConsiderForRanking` bit(1) DEFAULT NULL,
  `whetherShowInMarksheet` bit(1) DEFAULT NULL,
  `whetherMandatory` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_type_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_type_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `prog_batch_period_config` 
ADD COLUMN `placementTypeId` BIGINT(20) NULL AFTER `lastUpdate`,
ADD COLUMN `equivalentPeriodId` BIGINT(20) NULL AFTER `placementTypeId`;

ALTER TABLE `prog_batch_period_config` 
ADD INDEX `fk_prog_batch_period_config_1_idx` (`placementTypeId` ASC);
ALTER TABLE `prog_batch_period_config` 
ADD CONSTRAINT `fk_prog_batch_period_config_1`
  FOREIGN KEY (`placementTypeId`)
  REFERENCES `placement_type` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `prog_batch_period_config` 
ADD INDEX `fk_prog_batch_period_config_2_idx` (`equivalentPeriodId` ASC);
ALTER TABLE `prog_batch_period_config` 
ADD CONSTRAINT `fk_prog_batch_period_config_2`
  FOREIGN KEY (`equivalentPeriodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
