set foreign_key_checks=0;
CREATE TABLE `placement_document_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_document_master_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_document_master_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `placement_campus` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `campusCode` varchar(60) NOT NULL,
  `campusName` varchar(255) NOT NULL,
  `placementTypeId` bigint(20) NOT NULL,
  `campusCoordinator` bigint(20) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date DEFAULT NULL,
  `organizingAcademyLocationId` bigint(20) NOT NULL,
  `droolsRule` varchar(60) DEFAULT NULL,
  `whetherDocumentRequired` bit(1) DEFAULT NULL,
  `remarks` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_campus_1_idx` (`placementTypeId`),
  KEY `fk_placement_campus_2_idx` (`campusCoordinator`),
  KEY `fk_placement_campus_3_idx` (`organizingAcademyLocationId`),
  KEY `fk_placement_campus_5_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_campus_1` FOREIGN KEY (`placementTypeId`) REFERENCES `placement_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_2` FOREIGN KEY (`campusCoordinator`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_3` FOREIGN KEY (`organizingAcademyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_5` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



CREATE TABLE `placement_campus_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `placementCampusId` bigint(20) NOT NULL,
  `placementDoumentMasterId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_campus_document_1_idx` (`placementCampusId`),
  KEY `fk_placement_campus_document_2_idx` (`placementDoumentMasterId`),
  KEY `fk_placement_campus_document_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_campus_document_1` FOREIGN KEY (`placementCampusId`) REFERENCES `placement_campus` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_document_2` FOREIGN KEY (`placementDoumentMasterId`) REFERENCES `placement_document_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_document_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `placement_campus_recruiting_organization` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `placementCampusId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_campus_recruiting_organization_1_idx` (`placementCampusId`),
  KEY `fk_placement_campus_recruiting_organization_2_idx` (`academyLocationId`),
  KEY `fk_placement_campus_recruiting_organization_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_campus_recruiting_organization_1` FOREIGN KEY (`placementCampusId`) REFERENCES `placement_campus` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_recruiting_organization_2` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_recruiting_organization_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `placement_campus_academic_organization` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `placementCampusId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_campus_academic_organization_1_idx` (`placementCampusId`),
  KEY `fk_placement_campus_academic_organization_2_idx` (`academyLocationId`),
  KEY `fk_placement_campus_academic_organization_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_campus_academic_organization_1` FOREIGN KEY (`placementCampusId`) REFERENCES `placement_campus` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_academic_organization_2` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_academic_organization_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `placement_campus_period` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `placementCampusId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_campus_period_1_idx` (`placementCampusId`),
  KEY `fk_placement_campus_period_2_idx` (`periodId`),
  KEY `fk_placement_campus_period_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_campus_period_1` FOREIGN KEY (`placementCampusId`) REFERENCES `placement_campus` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_period_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_campus_period_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `placement_job` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobTitle` varchar(255) NOT NULL,
  `placementCampusId` bigint(20) NOT NULL,
  `recruitingOrganizationId` bigint(20) NOT NULL,
  `coordinatorId` bigint(20) NOT NULL,
  `selectionProcessId` bigint(20) DEFAULT NULL,
  `dateFrom` date NOT NULL,
  `dateTo` date DEFAULT NULL,
  `droolsRule` varchar(60) DEFAULT NULL,
  `description` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_1_idx` (`placementCampusId`),
  KEY `fk_placement_job_2_idx` (`recruitingOrganizationId`),
  KEY `fk_placement_job_3_idx` (`coordinatorId`),
  KEY `fk_placement_job_4_idx` (`selectionProcessId`),
  KEY `fk_placement_job_6_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_1` FOREIGN KEY (`placementCampusId`) REFERENCES `placement_campus` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_2` FOREIGN KEY (`recruitingOrganizationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_3` FOREIGN KEY (`coordinatorId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_4` FOREIGN KEY (`selectionProcessId`) REFERENCES `slctn_process` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_6` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `placement_job_location_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_location_master_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_location_master_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `placement_designation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_designation_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_designation_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `placement_job_location` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobId` bigint(20) NOT NULL,
  `jobLocationMasterId` bigint(20) NOT NULL,
  `coordinatorId` bigint(20) DEFAULT NULL,
  `designationId` bigint(20) DEFAULT NULL,
  `noOfPosition` int(11) DEFAULT NULL,
  `salaryPackage` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_location_1_idx` (`jobId`),
  KEY `fk_placement_job_location_2_idx` (`jobLocationMasterId`),
  KEY `fk_placement_job_location_3_idx` (`coordinatorId`),
  KEY `fk_placement_job_location_4_idx` (`designationId`),
  KEY `fk_placement_job_location_5_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_location_1` FOREIGN KEY (`jobId`) REFERENCES `placement_job` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_location_2` FOREIGN KEY (`jobLocationMasterId`) REFERENCES `placement_job_location_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_location_3` FOREIGN KEY (`coordinatorId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_location_4` FOREIGN KEY (`designationId`) REFERENCES `placement_designation` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_location_5` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
set foreign_key_checks=1;
