ALTER TABLE `placement_job` 
ADD COLUMN `whetherSelectionInBatches` BIT(1) NOT NULL DEFAULT b'0' AFTER `description`;



CREATE TABLE `placement_selection_stage` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobId` bigint(20) NOT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `minSeat` int(11) DEFAULT NULL,
  `maxSeat` int(11) DEFAULT NULL,
  `currentStatus` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entryRule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entryRuleDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `exitRule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `exitRuleDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `whetherFinalStage` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_selection_stage_1_idx` (`jobId`),
  KEY `fk_placement_selection_stage_2_idx` (`selectionProcessStageId`),
  KEY `fk_placement_selection_stage_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_selection_stage_1` FOREIGN KEY (`jobId`) REFERENCES `placement_job` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_selection_stage_2` FOREIGN KEY (`selectionProcessStageId`) REFERENCES `slctn_process_stage` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_selection_stage_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



CREATE TABLE `placement_job_application` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `recruitmentOrganizationId` bigint(20) DEFAULT NULL,
  `jobId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `applicationStatus` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `offerStatus` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `joiningStatus` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_application_1_idx` (`recruitmentOrganizationId`),
  KEY `fk_placement_job_application_2_idx` (`jobId`),
  KEY `fk_placement_job_application_3_idx` (`studentId`),
  KEY `fk_placement_job_application_4_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_1` FOREIGN KEY (`recruitmentOrganizationId`) REFERENCES `placement_campus_recruiting_organization` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_2` FOREIGN KEY (`jobId`) REFERENCES `placement_job` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_3` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_joining` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `confirmedBy` bigint(20) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_application_joining_1_idx` (`jobApplicationId`),
  KEY `fk_placement_job_application_joining_2_idx` (`confirmedBy`),
  KEY `fk_placement_job_application_joining_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_joining_1` FOREIGN KEY (`jobApplicationId`) REFERENCES `placement_job_application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_joining_2` FOREIGN KEY (`confirmedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_joining_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_location` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `joblocationId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_application_location_1_idx` (`jobApplicationId`),
  KEY `fk_placement_job_application_location_2_idx` (`joblocationId`),
  KEY `fk_placement_job_application_location_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_location_1` FOREIGN KEY (`jobApplicationId`) REFERENCES `placement_job_application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_location_2` FOREIGN KEY (`joblocationId`) REFERENCES `placement_job_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_location_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_offer` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `joblocationId` bigint(20) DEFAULT NULL,
  `salaryPackage` double(10,2) DEFAULT NULL,
  `dateOfJoining` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_application_offer_1_idx` (`jobApplicationId`),
  KEY `fk_placement_job_application_offer_2_idx` (`joblocationId`),
  KEY `fk_placement_job_application_offer_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_offer_1` FOREIGN KEY (`jobApplicationId`) REFERENCES `placement_job_application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_offer_2` FOREIGN KEY (`joblocationId`) REFERENCES `placement_job_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_offer_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_resume` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_application_resume_1_idx` (`jobApplicationId`),
  KEY `fk_placement_job_application_resume_2_idx` (`documentId`),
  KEY `fk_placement_job_application_resume_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_resume_1` FOREIGN KEY (`jobApplicationId`) REFERENCES `placement_job_application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_resume_2` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_resume_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_stage` (
  `id` bigint(20) NOT NULL,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `placementSelectionStageId` bigint(20) DEFAULT NULL,
  `currentStatus` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `totalMarks` float DEFAULT NULL,
  `stageMarks` float DEFAULT NULL,
  `rank` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_placement_job_application_stage_1_idx` (`jobApplicationId`),
  KEY `fk_placement_job_application_stage_2_idx` (`placementSelectionStageId`),
  KEY `fk_placement_job_application_stage_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_stage_1` FOREIGN KEY (`jobApplicationId`) REFERENCES `placement_job_application` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_stage_2` FOREIGN KEY (`placementSelectionStageId`) REFERENCES `placement_selection_stage` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_stage_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_stage_marks` (
  `id` bigint(20) NOT NULL,
  `jobApplicationStageId` bigint(20) NOT NULL,
  `evaluationParameterWeightageId` bigint(20) NOT NULL,
  `marksObtained` float DEFAULT NULL,
  `obtainedGrade` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `fk_placement_job_application_stage_marks_1_idx` (`jobApplicationStageId`),
  KEY `fk_placement_job_application_stage_marks_2_idx` (`evaluationParameterWeightageId`),
  KEY `fk_placement_job_application_stage_marks_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_job_application_stage_marks_1` FOREIGN KEY (`jobApplicationStageId`) REFERENCES `placement_job_application_stage` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_stage_marks_2` FOREIGN KEY (`evaluationParameterWeightageId`) REFERENCES `slctn_stage_eval_prm_weightage` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_placement_job_application_stage_marks_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


