CREATE TABLE IF NOT EXISTS `student_course_attendance_topic` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceId` bigint(20) NOT NULL,
  `topicId` bigint(20) DEFAULT NULL,
  `topicName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_course_attendance_topic_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `student_course_attendance_topic_attendanceId` (`attendanceId`),
  KEY `student_course_attendance_topic_topicId` (`topicId`),
  CONSTRAINT `student_course_attendance_topic_topicId` FOREIGN KEY (`topicId`) REFERENCES `course_topics` (`id`),
  CONSTRAINT `student_course_attendance_topic_attendanceId` FOREIGN KEY (`attendanceId`) REFERENCES `student_course_attendance` (`id`),
  CONSTRAINT `student_course_attendance_topic_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
