CREATE TABLE IF NOT EXISTS `student_specialization_enrollment` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `admissionId` BIGINT(20) NOT NULL,
    `programBatchCourseSpecialId` BIGINT(20) NOT NULL,
    `approveStatus` VARCHAR(45) NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `fk_prog_batch_period_config_admissionId_idx` (`admissionId` ASC),
    INDEX `fk_prog_batch_period_config_specialId_idx` (`programBatchCourseSpecialId` ASC),
    CONSTRAINT `fk_prog_batch_period_config_admissionId` FOREIGN KEY (`admissionId`)
        REFERENCES `admission` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_prog_batch_period_config_groupId` FOREIGN KEY (`programBatchCourseSpecialId`)
        REFERENCES `prog_batch_course_special` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_prog_batch_period_config_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION
);
