
/*************************Create entry for standard master medicine_details ************************/

CREATE TABLE `medicine_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `medicineName` varchar(45) DEFAULT NULL,
  `medicineCode` VARCHAR(45) NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_medicine_details_lastUpdateBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_medicine_details_lastUpdateBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master(`id`, `tableName`, `masterName`, `moduleName`,`filterCode`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'medicine_details', 'MEDICINE_DETAIL','Tools & Services','COMMON_MASTER', 0, 0, '1', SYSDATE());


INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES ('medicineName', 'MEDICINE_NAME', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());


INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES ('medicineCode', 'MEDICINE_CODE', @standardMasterMaxId + 1, 'varchar', '2', 0,0, 0, 0, '1', SYSDATE());

 /*************************Create table infirmary_details ************************/

CREATE TABLE `infirmary_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `doctorUserId` bigint(20) DEFAULT NULL,
  `userTypeId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `departmentId` bigint(20) DEFAULT NULL,
  `whetherAuthorityInformed` bit(1) DEFAULT b'0',
  `authorityUserId` bigint(20) DEFAULT NULL,
  `whetherParentInformed` bit(1) DEFAULT b'0',
  `parentUserId` bigint(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `timeIn` time DEFAULT NULL,
  `timeOut` time DEFAULT NULL,
  `infirmaryDate` date DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_infirmary_details_academyLocation_idx` (`academyLocationId`),
  KEY `fk_infirmary_details_periods_idx` (`periodId`),
  KEY `fk_infirmary_details_user_idx` (`userId`),
  KEY `fk_infirmary_details_authorityUser_idx` (`authorityUserId`),
  KEY `fk_infirmary_details_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_infirmary_details_department_idx` (`departmentId`),
  KEY `fk_infirmary_details_usergroup_idx` (`userTypeId`),
  KEY `fk_infirmary_details_doctorUserId_idx` (`doctorUserId`),
  KEY `fk_infirmary_details_parentUser_idx` (`parentUserId`),
  CONSTRAINT `fk_infirmary_details_academyLocation` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_authorityUser` FOREIGN KEY (`authorityUserId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_department` FOREIGN KEY (`departmentId`) REFERENCES `department` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_doctorUserId` FOREIGN KEY (`doctorUserId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_parentUser` FOREIGN KEY (`parentUserId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_periods` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_user` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_details_usergroup` FOREIGN KEY (`userTypeId`) REFERENCES `user_groups` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


/*************************Create table infirmary_medicine_details ************************/

CREATE TABLE `infirmary_medicine_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `infirmaryDetailId` bigint(20) DEFAULT NULL,
  `medicineId` bigint(20) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_infirmary_medicine_details_1_idx` (`infirmaryDetailId`),
  KEY `fk_infirmary_medicine_Id_idx` (`medicineId`),
  CONSTRAINT `fk_infirmary_medicine_Id` FOREIGN KEY (`medicineId`) REFERENCES `medicine_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_infirmary_medicine_details_1` FOREIGN KEY (`infirmaryDetailId`) REFERENCES `infirmary_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
