DROP TABLE IF EXISTS `program_group_addresses`;
DROP TABLE IF EXISTS `program_group_details`;

CREATE TABLE `program_group_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programGroupId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `eMISNumber` varchar(45) DEFAULT NULL,
  `countryRegionId` bigint(20) DEFAULT NULL,
  `logoPath` varchar(255) DEFAULT NULL,
  `isBoardingSchool` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `programGroupAcademy` (`programGroupId`,`academyLocationId`),
  KEY `fk_program_group_details_1_idx` (`programGroupId`),
  KEY `fk_program_group_details_2_idx` (`academyLocationId`),
  KEY `fk_program_group_details_3_idx` (`countryRegionId`),
  CONSTRAINT `fk_program_group_details_3` FOREIGN KEY (`countryRegionId`) REFERENCES `country_region` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `program_group_addresses` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `addressId` bigint(20) NOT NULL,
  `programGroupDetailId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_program_addresses_1_idx` (`addressId`),
  KEY `fk_program_user_id_idx` (`lastUpdatedBy`),
  KEY `fk_program_group_addresses_2_idx` (`programGroupDetailId`),
  CONSTRAINT `fk_program_addresses_1` FOREIGN KEY (`addressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_group_addresses_2` FOREIGN KEY (`programGroupDetailId`) REFERENCES `program_group_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_user_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



