CREATE TABLE `relationship_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` bit(1) DEFAULT false NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_relationship_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_relationship_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'relationship_type','RELATIONSHIP_TYPE','General','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'Relationship', @standardMasterMaxId+1, 'Boolean', '1', 0, 0, 0, 0, '1', SYSDATE());


insert into relationship_type (`itemCode`,`lastUpdate`,`lastUpdatedBy`) values(false,SYSDATE(),1);
