CREATE TABLE `discount_master` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '',
  `discountId` BIGINT(20) NOT NULL COMMENT '',
  `description` VARCHAR(255) NOT NULL COMMENT '',
  `whetherPercentage` BIT(1) NULL DEFAULT b'0' COMMENT '',
  `whetherFixedAmount` BIT(1) NULL DEFAULT b'0' COMMENT '',
  `rule` VARCHAR(255) NULL DEFAULT NULL COMMENT '',
  `whetherAdhoc` BIT(1) NULL DEFAULT b'0' COMMENT '',
  `whetherStandAlone` BIT(1) NULL DEFAULT b'0' COMMENT '',
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '',
  `lastUpdatedBy` BIGINT(20) NOT NULL COMMENT '',
  PRIMARY KEY (`id`)  COMMENT '',
  INDEX `fk_discountType_idx1234_idx` (`discountId` ASC)  COMMENT '',
  CONSTRAINT `fk_discountType_idx1234`
    FOREIGN KEY (`discountId`)
    REFERENCES `discount_type` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

CREATE TABLE `fee_plan_type_stage` (
  `id` BIGINT(20) NOT NULL COMMENT '',
  `feePlanTypeId` BIGINT(20) NOT NULL COMMENT '',
  `feeStageMasterId` BIGINT(20) NOT NULL COMMENT '',
  `discountMasterId` BIGINT(20) NOT NULL COMMENT '',
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT '',
  `lastUpdatedBy` BIGINT(20) NULL COMMENT '',
  PRIMARY KEY (`id`)  COMMENT '',
  INDEX `fk_new_table_fee_plan_type_id_idx` (`feePlanTypeId` ASC)  COMMENT '',
  INDEX `fk_new_table_feeStageMasterId_idx` (`feeStageMasterId` ASC)  COMMENT '',
  INDEX `fk_new_table_discount_master_Id_idx` (`discountMasterId` ASC)  COMMENT '',
  CONSTRAINT `fk_new_table_fee_plan_type_id`
    FOREIGN KEY (`feePlanTypeId`)
    REFERENCES `fee_plan_type` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_new_table_feeStageMasterId`
    FOREIGN KEY (`feeStageMasterId`)
    REFERENCES `fee_stage_master` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_new_table_discount_master_Id`
    FOREIGN KEY (`discountMasterId`)
    REFERENCES `discount_master` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);