CREATE TABLE `church_membershipstatus_mapping` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `churchInfoId` INT(11) NOT NULL,
  `membershipStatusId` INT(11) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_church_membershipStatus_ChurchId_idx` (`churchInfoId` ASC),
  INDEX `fk_church_membershipStatus_MembershipId_idx` (`membershipStatusId` ASC),
  INDEX `fk_church_membershipStatus_userId_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_church_membershipStatus_ChurchId`
    FOREIGN KEY (`churchInfoId`)
    REFERENCES `church_information` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_church_membershipStatus_MembershipId`
    FOREIGN KEY (`membershipStatusId`)
    REFERENCES `membership_status` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_church_membershipStatus_userId`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
