CREATE TABLE IF NOT EXISTS `program_phase` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'program_phase','PROGRAM_PHASE','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

ALTER TABLE `program_phase` 
ADD UNIQUE INDEX `itemCode_UNIQUE` (`itemCode` ASC),
ADD UNIQUE INDEX `itemValue_UNIQUE` (`itemValue` ASC);

ALTER TABLE `programs` 
ADD COLUMN `programPhaseId` BIGINT(20) NULL DEFAULT NULL AFTER `affiliatedUniversityId`,
ADD INDEX `fk_programs_phase_idx` (`programPhaseId` ASC),
ADD INDEX `fk_programs_affiliated_idx` (`affiliatedUniversityId` ASC);
ALTER TABLE `programs` 
ADD CONSTRAINT `fk_programs_phase`
  FOREIGN KEY (`programPhaseId`)
  REFERENCES `program_phase` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_programs_affiliated`
  FOREIGN KEY (`affiliatedUniversityId`)
  REFERENCES `affiliated_university` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


UPDATE `batches` SET `programEntryCreteria`=NULL, `programExitCreteria`=NULL WHERE `id`>0;

ALTER TABLE `batches` 
CHANGE COLUMN `programEntryCreteria` `entryCriteriaDroolId` BIGINT(20) NULL DEFAULT NULL ,
CHANGE COLUMN `programExitCreteria` `exitCriteriaDroolId` BIGINT(20) NULL DEFAULT NULL ,
ADD INDEX `fk_batches_entryDrool_idx` (`entryCriteriaDroolId` ASC),
ADD INDEX `fk_batches_exitDrool_idx` (`exitCriteriaDroolId` ASC);
ALTER TABLE `batches` 
ADD CONSTRAINT `fk_batches_entryDrool`
  FOREIGN KEY (`entryCriteriaDroolId`)
  REFERENCES `drool_rules` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_batches_exitDrool`
  FOREIGN KEY (`exitCriteriaDroolId`)
  REFERENCES `drool_rules` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

