set sql_safe_updates = 0;

CREATE TABLE exam_student_average_detail
as
select id as examStudentAverageId, planId, typeId, subTypeId, methodId, lastUpdatedBy, 
lastUpdate from exam_student_average;

ALTER TABLE exam_student_average_detail
add column id bigint(20) auto_increment primary key first;

ALTER TABLE exam_student_average_detail
ADD INDEX exam_student_average_detail_ibfk_1_idx(planId ASC),
ADD INDEX exam_student_average_detail_ibfk_2_idx(typeId ASC),
ADD INDEX exam_student_average_detail_ibfk_3_idx(subTypeId ASC),
ADD INDEX exam_student_average_detail_ibfk_4_idx(methodId ASC);

ALTER TABLE exam_student_average_detail
ADD CONSTRAINT FK_exam_student_average_detail_examStudentAverageId
FOREIGN KEY (examStudentAverageId) REFERENCES exam_student_average(id),
ADD CONSTRAINT FK_exam_student_average_detail_PlanId
FOREIGN KEY (planId) REFERENCES evaluation_plan(id),
ADD CONSTRAINT FK_exam_student_average_detail_typeId
FOREIGN KEY (typeId) REFERENCES evaluation_plan_level_one(id),
ADD CONSTRAINT FK_exam_student_average_detail_subTypeId
FOREIGN KEY (subTypeId) REFERENCES evaluation_plan_level_two(id),
ADD CONSTRAINT FK_exam_student_average_detail_methodId
FOREIGN KEY (methodId) REFERENCES evaluation_sequence(id),
ADD CONSTRAINT FK_exam_student_average_detail_lastUpdatedBy 
FOREIGN KEY (lastUpdatedBy) REFERENCES users(id);

ALTER TABLE exam_student_average 
DROP FOREIGN KEY exam_student_average_ibfk_3,
DROP FOREIGN KEY exam_student_average_ibfk_4,
DROP FOREIGN KEY exam_student_average_ibfk_5,
DROP FOREIGN KEY exam_student_average_ibfk_6;

alter table exam_student_average
drop column planId,
drop column typeId,
drop column subTypeId,
drop column methodId;
set sql_safe_updates = 1;