CREATE 
VIEW `course_view` AS
    select 
        `cou`.`courseName` AS `Name`,
        `cou`.`courseCode` AS `Code`,
        `dept`.`deptName` AS `DepartmentName`,
        `dept`.`shortCode` AS `DepartmentCode`,
        `cou`.`courseCredits` AS `Credit`
    from
        (`courses` `cou`
        join `department` `dept` ON ((`dept`.`id` = `cou`.`departmentId`)));

CREATE 
VIEW `department_view` AS
    select 
        `dept`.`deptName` AS `Name`,
        `dept`.`shortCode` AS `Code`,
        `dept`.`deptType` AS `Category`
    from
        `department` `dept`;

CREATE
VIEW `faculty_view` AS
    select 
        `usr`.`code` AS `RegistrationId`,
        `usr`.`printName` AS `Name`,
        `per`.`emailId` AS `Email`,
        `per`.`mobileNumber` AS `Phone`,
        `dpt`.`deptName` AS `DepartmentName`,
        `dpt`.`shortCode` AS `DepartmentCode`,
        `per`.`gender` AS `Gender`
    from
        (((`staffs` `stf`
        join `users` `usr` ON ((`usr`.`id` = `stf`.`userId`)))
        join `persons` `per` ON ((`per`.`id` = `stf`.`personId`)))
        join `department` `dpt` ON ((`dpt`.`id` = `stf`.`departmentId`)))
    where
        ((`stf`.`whetherFaculty` = 1)
            and (`usr`.`status` = 1)
            and (`usr`.`whetherDeleted` = 0));

CREATE 
VIEW `program_view` AS
    select 
        `prg`.`programName` AS `Name`,
        `prg`.`programCode` AS `Code`,
        `dpt`.`deptName` AS `DepartmentName`,
        `dpt`.`shortCode` AS `DepartmentCode`,
        `bch`.`batchName` AS `Batch`,
        `bch`.`startDate` AS `StartDate`,
        `bch`.`tillDate` AS `TillDate`,
        `ppt`.`typeName` AS `System`
    from
        (((`programs` `prg`
        join `batches` `bch` ON ((`bch`.`programId` = `prg`.`id`)))
        join `program_period_type` `ppt` ON ((`ppt`.`id` = `bch`.`programPeriodTypeId`)))
        join `department` `dpt` ON ((`prg`.`programDepartmentId` = `dpt`.`id`)))
    where
        (`prg`.`status` = 'O');

CREATE
VIEW `section_view` AS
    select 
        `sec`.`sectionCode` AS `Name`,
        `sec`.`sectionCode` AS `Code`,
        `ity`.`itemCode` AS `BatchYear`,
        `prg`.`programName` AS `ProgramCode`
    from
        ((((`sections` `sec`
        join `prog_batch_period_config` `per` ON ((`per`.`id` = `sec`.`periodId`)))
        join `batches` `bch` ON ((`bch`.`id` = `per`.`programBatchId`)))
        join `intake_year` `ity` ON ((`ity`.`id` = `bch`.`intakeYearId`)))
        join `programs` `prg` ON ((`prg`.`id` = `bch`.`programId`)));
        
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) VALUES ('2', 'AU_PLAN_LEVEL_MARKSHEET', 'AU Plan Level Marksheet', 'AU_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'Footer_IMI.jasper', '1', '1', 'AU_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png');
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) VALUES ('8', 'IIHMR_COURSE_LEVEL_HALL_TICKET', 'IIHMR Hall Ticket', 'IIHMR_COURSE_LEVEL_HALL_TICKET.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'IIHMR_COURSE_LEVEL_HALL_TICKET.jasper', 'AcademiaLogo.png');

