CREATE TABLE `parent_student_mapping` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `parentPersonId` BIGINT(20) NOT NULL,
  `parentUserId` BIGINT(20) NULL DEFAULT NULL,
  `studentId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `index_parentPersonId` (`parentPersonId` ASC),
  INDEX `index_parentUserId` (`parentUserId` ASC),
  INDEX `index_studentId` (`studentId` ASC),
  CONSTRAINT `fk_parentPersonId`
    FOREIGN KEY (`parentPersonId`)
    REFERENCES `persons` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_parentUserId`
    FOREIGN KEY (`parentUserId`)
    REFERENCES `parents` (`userId`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_studentId`
    FOREIGN KEY (`studentId`)
    REFERENCES `students` (`userId`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
