DROP TRIGGER IF EXISTS program_marksheet_trigger;
DELIMITER //
CREATE TRIGGER program_marksheet_trigger 
 AFTER UPDATE ON programs 
 FOR EACH ROW 
BEGIN
IF NEW.programNameToBePrint <=> OLD.programNameToBePrint || NEW.programNameToBePrint <> OLD.programNameToBePrint THEN
	set sql_safe_updates=0;

update marksheet set programName=NEW.programNameToBePrint where 
programId =OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS batches_marksheet_trigger;
DELIMITER //
CREATE TRIGGER batches_marksheet_trigger 
 AFTER UPDATE ON batches 
 FOR EACH ROW 
BEGIN
IF NEW.printName <=> OLD.printName || NEW.printName <> OLD.printName THEN
	set sql_safe_updates=0;

update marksheet set batchName=NEW.printName where 
batchId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;


DROP TRIGGER IF EXISTS period_marksheet_trigger;
DELIMITER //
CREATE TRIGGER period_marksheet_trigger 
 AFTER UPDATE ON prog_batch_period_config 
 FOR EACH ROW 
BEGIN
IF NEW.printName <=> OLD.printName || NEW.printName <> OLD.printName THEN
	set sql_safe_updates=0;

update marksheet set periodName=NEW.printName where 
periodId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS sections_Name_marksheet_trigger;
DELIMITER //
CREATE TRIGGER sections_Name_marksheet_trigger 
 AFTER UPDATE ON sections 
 FOR EACH ROW 
BEGIN
IF NEW.alternateName <=> OLD.alternateName || NEW.alternateName <> OLD.alternateName THEN
	set sql_safe_updates=0;

update marksheet set sectionName=NEW.alternateName where 
sectionId=OLD.id;

	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS courses_marksheet_trigger;
DELIMITER //
CREATE TRIGGER courses_marksheet_trigger 
 AFTER UPDATE ON courses 
 FOR EACH ROW 
BEGIN
IF NEW.nameToBePrinted <=> OLD.nameToBePrinted || NEW.nameToBePrinted <> OLD.nameToBePrinted || NEW.courseCode
<=> OLD.courseCode || NEW.courseCode <> OLD.courseCode THEN
	set sql_safe_updates=0;

update marksheet set courseName=NEW.nameToBePrinted, courseCode=NEW.courseCode where 
courseId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS courseVariant_code_marksheet_trigger;
DELIMITER //
CREATE TRIGGER courseVariant_code_marksheet_trigger 
 AFTER UPDATE ON course_variants 
 FOR EACH ROW 
BEGIN
IF NEW.courseVariantCode <=> OLD.courseVariantCode || NEW.courseVariantCode <> OLD.courseVariantCode THEN
	set sql_safe_updates=0;

update marksheet set courseVariant=NEW.courseVariantCode where 
courseVariantId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS evaluation_plan_trigger;
DELIMITER //
CREATE TRIGGER evaluation_plan_trigger 
 AFTER UPDATE ON evaluation_plan
 FOR EACH ROW 
BEGIN
IF NEW.printNameInMarksheet <=> OLD.printNameInMarksheet || NEW.printNameInMarksheet <> OLD.printNameInMarksheet || NEW.evaluationPlanNumber <=> OLD.evaluationPlanNumber || NEW.evaluationPlanNumber <> OLD.evaluationPlanNumber THEN
	set sql_safe_updates=0;

update marksheet set evaluationPlan=NEW.evaluationPlanNumber, planPrintName=NEW.printNameInMarksheet where 
evaluationPlanId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;


DROP TRIGGER IF EXISTS eval_plan_level_one_trigger;
DELIMITER //
CREATE TRIGGER eval_plan_level_one_trigger 
 AFTER UPDATE ON evaluation_plan_level_one 
 FOR EACH ROW 
BEGIN
IF NEW.printNameInMarksheet <=> OLD.printNameInMarksheet || NEW.levelName <=> OLD.levelName ||
NEW.printNameInMarksheet <> OLD.printNameInMarksheet || NEW.levelName <> OLD.levelName THEN
	set sql_safe_updates=0;

update marksheet set levelOnePrintName=NEW.printNameInMarksheet, evaluationLevelOne=NEW.levelName where 
evaluationPlanLevelOneId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS evaluation_plan_level_two_trigger;
DELIMITER //
CREATE TRIGGER evaluation_plan_level_two_trigger 
 AFTER UPDATE ON evaluation_plan_level_two 
 FOR EACH ROW 
BEGIN
IF NEW.printNameInMarksheet <=> OLD.printNameInMarksheet || NEW.levelName <=> OLD.levelName ||
NEW.printNameInMarksheet <> OLD.printNameInMarksheet || NEW.levelName <> OLD.levelName THEN
	set sql_safe_updates=0;

update marksheet set levelTwoPrintName=NEW.printNameInMarksheet, evaluationLevelTwo=NEW.levelName where 
evaluationPlanLevelTwoId=OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS method_level_marksheet_trigger;
DELIMITER //
CREATE TRIGGER method_level_marksheet_trigger 
 AFTER UPDATE ON evaluation_sequence 
 FOR EACH ROW 
BEGIN
IF NEW.printNameInMarksheet <=> OLD.printNameInMarksheet || NEW.printNameInMarksheet <> OLD.printNameInMarksheet THEN
	set sql_safe_updates=0;

update marksheet
	join evaluation_sequence on evaluation_sequence.id=OLD.id
	join sequence_header on evaluation_sequence.evalSequenceId=sequence_header.id
	set marksheet.evaluationLevelThree=sequence_header.sequenceName,
	marksheet.levelThreePrintName=evaluation_sequence.printNameInMarksheet
where marksheet.evaluationPlanThreeId=OLD.id;
	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS users_marksheet_trigger;
DELIMITER //
CREATE TRIGGER users_marksheet_trigger 
 AFTER UPDATE ON users 
 FOR EACH ROW 
BEGIN
IF NEW.printName <=> OLD.printName || NEW.printName <> OLD.printName THEN
	set sql_safe_updates=0;

update marksheet set stdName=NEW.printName where 
studentId=OLD.id;

	set sql_safe_updates=1;
END IF;
END;//
DELIMITER ;

DROP TRIGGER IF EXISTS evaluation_student_remark_marksheet_trigger;
DELIMITER //
CREATE TRIGGER evaluation_student_remark_marksheet_trigger 
 AFTER UPDATE ON evaluation_student_remark 
 FOR EACH ROW 
BEGIN
IF NEW.remark <=> OLD.remark || NEW.remark <> OLD.remark THEN
	set sql_safe_updates=0;

		-- Type Level Subject Remark
		IF(OLD.courseVariantId IS NOT NULL && OLD.evalPlanLevelOneId IS NOT NULL) then

		UPDATE marksheet set remark=NEW.remark where courseVariantId=OLD.courseVariantId
		and evaluationPlanLevelOneId=OLD.evalPlanLevelOneId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelTwoId IS NULL;

		-- Type Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalPlanLevelOneId IS NOT NULL) THEN

		UPDATE marksheet set remark=NEW.remark where courseVariantId is null
		and evaluationPlanLevelOneId=OLD.evalPlanLevelOneId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelTwoId IS NULL;

		
		-- Sub Type Level Subject Remark
		ELSEIF (OLD.courseVariantId IS NOT NULL && OLD.evalPlanLevelTwoId IS NOT NULL) THEN
		
		UPDATE marksheet set remark=NEW.remark where
		evaluationPlanLevelTwoId=OLD.evalPlanLevelTwoId and courseVariantId=OLD.courseVariantId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanThreeId IS NULL;

		
		-- Sub Type Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalPlanLevelTwoId IS NOT NULL) THEN
		
		UPDATE marksheet set remark=NEW.remark where courseVariantId is null
		and evaluationPlanLevelTwoId=OLD.evalPlanLevelTwoId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanThreeId IS NULL;

		-- Method Level Subject Remark
		ELSEIF (OLD.courseVariantId IS NOT NULL && OLD.evalSequenceId IS NOT NULL) THEN
		
		UPDATE marksheet set remark=NEW.remark where
		evaluationPlanThreeId=OLD.evalSequenceId and courseVariantId=OLD.courseVariantId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelFourId IS NULL;

		
		-- Method Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalSequenceId IS NOT NULL) THEN
		
		UPDATE marksheet set remark=NEW.remark where courseVariantId is null
		and evaluationPlanThreeId=OLD.evalSequenceId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelFourId IS NULL;
		
		END IF;

	set sql_safe_updates=1;
END IF;
END //
DELIMITER ;



DROP TRIGGER IF EXISTS marksheet_remark_insert_trigger;
DELIMITER //
CREATE TRIGGER marksheet_remark_insert_trigger 
AFTER INSERT ON evaluation_student_remark 
FOR EACH ROW 
BEGIN
-- create temporary table if not exists templog (msg varchar(2048), id bigint(11));
-- insert into templog values('Trigger started',NEW.id);
if(
select count(marksheet.id) 
from marksheet 
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and (
	(NEW.evalSequenceId is not null and NEW.evalSequenceId=marksheet.evaluationPlanThreeId)
	or (NEW.evalPlanLevelTwoId is not null and NEW.evalPlanLevelTwoId=marksheet.evaluationPlanLevelTwoId 
    and marksheet.evaluationPlanThreeId is null)
    or (NEW.evalPlanLevelOneId is not null and NEW.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
    and marksheet.evaluationPlanLevelTwoId is null)
    )
limit 1) = 0
then
-- insert into templog values('After first if not in marksheet',NEW.admissionId);
   if(NEW.evalPlanLevelOneId IS NOT NULL && NEW.remark is not null) then
-- insert into templog values('Level One',NEW.evalPlanLevelOneId);
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber,type.id,type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark,type.printNameInMarksheet,type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
-- insert into templog values('Level One completed',NEW.courseVariantId);
    
	elseif(NEW.evalPlanLevelTwoId IS NOT NULL && NEW.remark is not null) then
-- insert into templog values('Level two',NEW.id);
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,subType.id,subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, subType_type.printNameInMarksheet,subType.printNameInMarksheet,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;

	elseif(NEW.evalSequenceId IS NOT NULL && NEW.remark is not null) then
-- insert into templog values('Level three',NEW.id);
	INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `evaluationPlanThreeId`, `evaluationLevelThree`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `levelThreePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,method.id, sequence_header.sequenceName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,method.printNameInMarksheet, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
-- insert into templog values('End insert statment',NEW.id);
	end if;
-- insert into templog values('End marksheet table check',NEW.id);
end if;
-- insert into templog values('end trigger',NEW.id);

END //
DELIMITER ;


