set sql_safe_updates=0;
UPDATE `report_type` SET `typeName`='Student Statement of Account' WHERE `id`='6';
UPDATE `report_template` SET `templateName`='Voucher Based Statement of Account' WHERE `templateCode`='STATEMENT_OF_ACCOUNT_REPORT';
set sql_safe_updates=1;

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('6', 'VELOCITY_STATEMENT_OF_ACCOUNT', 'Velocity Statement of Account', 'VELOCITY_STATEMENT_OF_ACCOUNT.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VelocityStatementOfAccount.jasper', 'AcademiaLogo.png');

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('6', 'STATEMENT_OF_ACCOUNT', 'Statement of Account', 'STATEMENT_OF_ACCOUNT.png', 'CommonReport_StatementOfAccount_OPJGU.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'StatementOfAccount.jasper', 'AcademiaLogo.png');

set @VelocityStatementOfAccountTempId = (select max(id) from report_template where templateCode ='VELOCITY_STATEMENT_OF_ACCOUNT');
set @StatementOfAccountTempId = (select max(id) from report_template where templateCode ='STATEMENT_OF_ACCOUNT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@VelocityStatementOfAccountTempId, 'TRANS_STATEMENT', 'Statement', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_DATE', 'Date', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_ACCOUNT', 'Account no.', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_STUDENT_NAME', 'Student Name	', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_APPLICANT_NAME', 'Applicant Name', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_GRADE', 'Grade', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_TO', 'To:', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_NOTES', 'Notes:', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_REFERENCE', 'Reference', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_DESCRIPTION', 'Description', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_DEBIT', 'Debit', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_CREDIT', 'Credit', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_BALANCE', 'Balance', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_BANKING_DETAILS', 'Banking Details', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_QUERIES', 'FOR ANY QUERIES KINDLY CONTACT OUR CAMPUS \nBURSAR:', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_EFT', 'Please Use EFT reference ', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_Line1', 'Monthly Fees are Payable in Advance.', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_Line2', '(i.e June Fees are Payable by 1st June)', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_TELEPHONE', 'Telephone', '1', NOW()),
(@VelocityStatementOfAccountTempId, 'TRANS_BANKING_DETAILS', 'Banking Details', '1', NOW());

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@StatementOfAccountTempId, 'TRANS_STATEMENT', 'STATEMENT OF ACCOUNT', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_STUDENTID', 'Student ID: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_STUDENT_NAME', 'Student Name: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_PROGRAM', 'Program: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_BATCH', 'Batch: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_PERIOD', 'Period: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_STATEMENT_DATE', 'Statement Date: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_STATEMENT_PERIOD', 'Statement Period: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_TELEPHONE', 'Telephone: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_EMAIL', 'Email: ', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_TXN_DATE', 'Transaction Date', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_TXN_NUMBER', 'Transcation No.', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_TXN_TYPE', 'Transcation Type', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_DESCRIPTION', 'Description', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_DEBIT', 'Debit', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_CREDIT', 'Credit', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_BALANCE', 'Balance', '1', NOW()),
(@StatementOfAccountTempId, 'TRANS_TOTAL', 'TOTAL', '1', NOW());
