DROP view IF EXISTS `pending_attendance_view`;

CREATE VIEW `pending_attendance_view` AS
    SELECT 
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `loc`.`id` AS `LOCATION_ID`,
        `loc`.`locationName` AS `LOCATION_NAME`,
        `ad`.`academyName` AS `ACADEMY_NAME`,
        `pgrm`.`programName` AS `programName`,
        `pgrm`.`id` AS `PROGRAM_ID`,
        `b`.`batchName` AS `batchName`,
        `pbp`.`programPeriodName` AS `programPeriodName`,
        `s`.`sectionCode` AS `sectionCode`,
        `pbp`.`programPeriodStart` AS `programPeriodStart`,
        `pbp`.`programPeriodEnd` AS `programPeriodEnd`,
        `td`.`trans_date` AS `trans_date`,
        `td`.`day_name` AS `day_name`,
        `prsn`.`printName` AS `facultyName`,
        `pgrm`.`programSequence` AS `programSequence`,
        `s`.`id` AS `SectionId`,
        `pgrm_cat`.`categoryName` AS `programCategory`
    FROM
        ((((((((((((((`sections` `s`
        JOIN `prog_batch_period_config` `pbp` ON (((`s`.`periodId` = `pbp`.`id`)
            AND (`pbp`.`isCurrentPeriodOfProgram` = 1))))
        JOIN `batches` `b` ON ((`b`.`id` = `pbp`.`programBatchId`)))
        JOIN `programs` `pgrm` ON ((`pgrm`.`id` = `b`.`programId`)))
        JOIN `program_category` `pgrm_cat` ON ((`pgrm_cat`.`id` = `pgrm`.`programCategoryId`)))
        JOIN `academy_location` `al` ON ((`al`.`id` = `pgrm`.`academyLocationId`)))
        JOIN `academies` `ad` ON ((`ad`.`id` = `al`.`academyId`)))
        JOIN `locations` `loc` ON ((`loc`.`id` = `al`.`locationId`)))
        JOIN `staffs` `st` ON ((`st`.`userId` = `s`.`facultyId`)))
        JOIN `persons` `prsn` ON ((`prsn`.`id` = `st`.`personId`)))
        JOIN `time_dimension` `td` ON (((`td`.`trans_date` BETWEEN `pbp`.`programPeriodStart` AND `pbp`.`programPeriodEnd`)
            AND (`td`.`trans_date` <= CURDATE())
            AND (`pbp`.`programPeriodEnd` >= CURDATE()))))
        JOIN `calendar_working_weekdays` `cww` ON ((`cww`.`calendarId` = `b`.`calendarId`)))
        JOIN `calendar_weekdays` `cw` ON (((`cww`.`calendarWeekdayId` = `cw`.`id`)
            AND (`cw`.`weekDay` = `td`.`day_name`))))
        LEFT JOIN `student_program_attendance` `spa` ON (((`s`.`id` = `spa`.`sectionId`)
            AND (`s`.`facultyId` = `spa`.`facultyId`)
            AND (`spa`.`dateOfAttendance` = `td`.`trans_date`)
            AND (`spa`.`attendanceType` = 'COMPLETE_DAY'))))
        LEFT JOIN `pending_attendance_time_dimension_view` `cal_holi` ON (((`td`.`trans_date` = `cal_holi`.`trans_date`)
            AND (`cal_holi`.`calendarId` = `b`.`calendarId`))))
    WHERE
        (ISNULL(`spa`.`id`)
            AND ISNULL(`cal_holi`.`trans_date`)
            AND (`td`.`trans_date` >= (NOW() - INTERVAL 3 MONTH)))