DELIMITER $$

DROP PROCEDURE IF EXISTS InsertUITranslationGroupAssignment $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE InsertUITranslationGroupAssignment()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'CREATE_GROUP_MANNUALLY' )) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','CREATE_GROUP_MANNUALLY','Create Group Manually','Create Group Manually',now(),1);
   
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'SELECT_GROUP' )) THEN
    	    
    INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','SELECT_GROUP','Select Group','Select Group',now(),1);
        
  END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'FROM_EXISTING_GROUP_ASSIGNMENT' )) THEN
    
    INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','FROM_EXISTING_GROUP_ASSIGNMENT','From existing assignment of current variant','From existing assignment of current variant',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'HW_ASSIGNMENT_GROUP_NAME_ALREADY_EXIST' )) THEN
    
    INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','HW_ASSIGNMENT_GROUP_NAME_ALREADY_EXIST','Group name already exists.','Group name already exists.',now(),1);

  END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'HW_ASSIGNMENT_GROUP_ALREADY_ADDED' )) THEN
    
    INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','HW_ASSIGNMENT_GROUP_ALREADY_ADDED','Group already added','Group already added',now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PROGRAMANDCOURSE' and keyName = 'HW_ASSIGNMENT_CONFIGURE_NOTIFICATION' )) THEN
    
    INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('PROGRAMANDCOURSE','HW_ASSIGNMENT_CONFIGURE_NOTIFICATION','Configure Notification', 'Configure Notification',now(),1);

  END IF;
  
END $$


-- Execute the stored procedure
CALL InsertUITranslationGroupAssignment() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS InsertUITranslationGroupAssignment $$
 
DELIMITER ;