DELIMITER $$

DROP PROCEDURE IF EXISTS MultipleFinancialRecordAlert $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE MultipleFinancialRecordAlert()

BEGIN
  
  -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='FEEANDPAYMENTS' And keyName= 'MULTIPLE_FINANCIAL_RECORD_MESSAGE')) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`) VALUES
	('FEEANDPAYMENTS', 'MULTIPLE_FINANCIAL_RECORD_MESSAGE', 'You cannot print fully pending receipts along with settled receipts. Please make separate selections.', 'You cannot print fully pending receipts along with settled receipts. Please make separate selections.', now(), '1');

  END IF;

END $$

-- Execute the stored procedure
CALL MultipleFinancialRecordAlert() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS MultipleFinancialRecordAlert $$
 
DELIMITER ;