DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071812__Insert_translation_TIME_TABLE_DELETE_FOR_FACULTY $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071812__Insert_translation_TIME_TABLE_DELETE_FOR_FACULTY()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='TIME_TABLE_DELETE_FOR_FACULTY')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','TIME_TABLE_DELETE_FOR_FACULTY','Time Table Delete For Faculty','Time Table Delete For Faculty',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='TIME_TABLE_DELETE_FOR_FACULTY_DL')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','TIME_TABLE_DELETE_FOR_FACULTY_DL','Time Table Delete For Faculty DL','Time Table Delete For Faculty DL',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='TIME_TABLE_DELETE_FOR_FACULTY_RCPNT')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','TIME_TABLE_DELETE_FOR_FACULTY_RCPNT','Time Table Delete For Faculty Recipient','Time Table Delete For Faculty Recipient',now(),1);
 END IF;
 
 IF NOT EXISTS ((select * from picklist_translation where 'key'='TIME_TABLE_DELETE_FOR_FACULTY' and 'en'='Time Table Delete For Faculty')) THEN
    
	INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('TIME_TABLE_DELETE_FOR_FACULTY', 'Time Table Delete For Faculty');
 END IF;
 
 IF NOT EXISTS ((select * from picklist_translation where 'key'='TIME_TABLE_DELETE_FOR_FACULTY_DL' and 'en'='Time Table Delete For Faculty DL')) THEN
    
	INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('TIME_TABLE_DELETE_FOR_FACULTY_DL', 'Time Table Delete For Faculty DL');
 END IF;
 
 IF NOT EXISTS ((select * from picklist_translation where 'key'='TIME_TABLE_DELETE_FOR_FACULTY_RCPNT' and 'en'='Time Table Delete For Faculty Recipient')) THEN
    
	INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('TIME_TABLE_DELETE_FOR_FACULTY_RCPNT', 'Time Table Delete For Faculty Recipient');
 END IF;



END $$

-- Execute the stored procedure
CALL V202001071812__Insert_translation_TIME_TABLE_DELETE_FOR_FACULTY() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071812__Insert_translation_TIME_TABLE_DELETE_FOR_FACULTY $$
 
DELIMITER ;
