DELIMITER $$

DROP PROCEDURE IF EXISTS LATEST_PAYSLIP $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE LATEST_PAYSLIP()

BEGIN
  
  -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'LATEST_PAYSLIP' and  objectName ='PERSON')) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PERSON','LATEST_PAYSLIP','Latest Payslip','Latest Payslip',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL LATEST_PAYSLIP() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS LATEST_PAYSLIP $$
 
DELIMITER ;