DELIMITER $$

DROP PROCEDURE IF EXISTS add_report_template $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_report_template()

BEGIN
  
	-- Insert new record in report_template table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STUDENTS_ELIGIBILITY_SHEET' )) THEN
    
	-- Insert Query 
    INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('10', 'STUDENTS_ELIGIBILITY_SHEET', 'Student\"s Eligibility Sheet', 'STUDENTS_ELIGIBILITY_SHEET.png', 'CommonReport_LandScape.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'STUDENTS_ELIGIBILITY_SHEET.jasper', 'AcademiaLogo.png');

  END IF;

	-- Insert new record in report_template_translations table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='STUDENTS_ELIGIBILITY_SHEET'))) THEN
    
	set @StudentEligibilitySheet = (select id from report_template where templateCode ='STUDENTS_ELIGIBILITY_SHEET');
	-- Insert Query 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@StudentEligibilitySheet, 'TRANS_TITLE', 'Eligibility Sheet -', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_PRIMARY_TITLE', 'End of', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_ROLL_NO', 'Roll No.:', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_NAME', 'Name:', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_COURSE_NO', 'Course No.', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_COURSE_TITLE', 'Course Title', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_CREDITS', 'Credits', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_TOTAL_CREDITS', 'Total Credits', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_SECONDARY_TITLE', 'Legends', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_ROW_ONE', 'BL', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_ROW_TWO', 'RP', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_ROW_THREE', 'DC', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_VALUE_ONE', 'Backlog Course', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_VALUE_TWO', 'Repeat Course', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_VALUE_THREE', 'Dependent Course', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_CGPA', 'CGPA:', '1', NOW()),
	(@StudentEligibilitySheet, 'TRANS_PROGRAM_CREDITS', 'Total Program Credits:', '1', NOW());

  END IF;

END $$

-- Execute the stored procedure
CALL add_report_template() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_report_template $$
 
DELIMITER ;