DELIMITER $$

DROP PROCEDURE IF EXISTS V202001141629__Insert_AdmissionActivityReportUITranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001141629__Insert_AdmissionActivityReportUITranslation()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="ADMISSION" and keyName="USER_ACTIVITY_REPORT" )) THEN
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','USER_ACTIVITY_REPORT','User Activity Report','User Activity Report',now(),1);
  END IF;
  
    IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="ADMISSION" and keyName="SALES_AND_ADMISSION_ENROLMENT_SUMMARY_REPORT" )) THEN
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','SALES_AND_ADMISSION_ENROLMENT_SUMMARY_REPORT','Sales and Admission Enrolment Summary Report','Sales and Admission Enrolment Summary Report',now(),1);
  END IF;

END $$

-- Execute the stored procedure
CALL V202001141629__Insert_AdmissionActivityReportUITranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001141629__Insert_AdmissionActivityReportUITranslation $$
 
DELIMITER ;