DELIMITER $$

DROP PROCEDURE IF EXISTS V202001151611__CreateCurrencyExchangeTable $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001151611__CreateCurrencyExchangeTable()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='currency_exchange' )) THEN
    
CREATE TABLE `currency_exchange` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fromCurrencyId` bigint(20) NOT NULL,
  `toCurrencyId` bigint(20) NOT NULL,
  `exchangeRate` double(20,2) NOT NULL,
  `applicableFrom` date NOT NULL,
  `applicableTill` date NOT NULL,
  `status` bit(1) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_currency_exchange_fromCurrencytoCurrency_idx` (`fromCurrencyId`),
  KEY `fk_currency_exchange_toCurrencytoCurrency_idx` (`toCurrencyId`),
  KEY `fk_currency_exchange_toUser_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_currency_exchange_fromCurrencytoCurrency` FOREIGN KEY (`fromCurrencyId`) REFERENCES `currency` (`id`),
  CONSTRAINT `fk_currency_exchange_toCurrencytoCurrency` FOREIGN KEY (`toCurrencyId`) REFERENCES `currency` (`id`),
  CONSTRAINT `fk_currency_exchange_toUser` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001151611__CreateCurrencyExchangeTable() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001151611__CreateCurrencyExchangeTable $$
 
DELIMITER ;