DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291656__AlterPaymentHeader $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291656__AlterPaymentHeader()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='payment_header' 
  AND column_name='acadLocCurrencyAmount')) THEN
  
   ALTER TABLE `payment_header` 
ADD COLUMN `acadLocCurrencyAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `cancellationDate`,
ADD COLUMN `orgCurrencyAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrencyAmount`,
ADD COLUMN `acadLocCurrencyConvertionId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrencyAmount`,
ADD COLUMN `orgCurrencyConvertionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConvertionId`,
ADD COLUMN `acadLocCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrencyConvertionId`,
ADD COLUMN `orgCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyId`,
ADD INDEX `RefPaymentHeaderToAcademyLocationCurreyConvertion_idx` (`acadLocCurrencyConvertionId` ASC),
ADD INDEX `RefPaymentToOrgCurrencyConversion_idx` (`orgCurrencyConvertionId` ASC),
ADD INDEX `RefALAmountTOCurrency_idx` (`acadLocCurrencyId` ASC),
ADD INDEX `RefOrgAmountTOCurrency_idx` (`orgCurrencyId` ASC);

ALTER TABLE `payment_header` 
ADD CONSTRAINT `RefPaymentHeaderToAcademyLocationCurreyConvertion`
  FOREIGN KEY (`acadLocCurrencyConvertionId`)
  REFERENCES `currency_exchange_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `RefPaymentToOrgCurrencyConversion`
  FOREIGN KEY (`orgCurrencyConvertionId`)
  REFERENCES `currency_exchange_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `RefALAmountTOCurrency`
  FOREIGN KEY (`acadLocCurrencyId`)
  REFERENCES `currency` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `RefOrgAmountTOCurrency`
  FOREIGN KEY (`orgCurrencyId`)
  REFERENCES `currency` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291656__AlterPaymentHeader $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291656__AlterPaymentHeader $$
 
DELIMITER ;