DELIMITER $$

DROP PROCEDURE IF EXISTS V202001301433__Alter_ApplicationReference $$

CREATE PROCEDURE V202001301433__Alter_ApplicationReference()

BEGIN
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='salutationId')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `salutationId` bigint(20) NULL DEFAULT NULL;

		ALTER TABLE `application_references` 
		ADD CONSTRAINT `application_references_salutationId`
		  FOREIGN KEY (`salutationId`)
		  REFERENCES `salutations` (`id`)
		  ON DELETE NO ACTION
		  ON UPDATE NO ACTION;

	END IF;

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='emailId')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `emailId` varchar(255) NULL DEFAULT NULL;

	END IF;
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='affiliation')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `affiliation` varchar(255) NULL DEFAULT NULL;
		
	END IF;

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='waived')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `waived` varchar(255) NULL DEFAULT NULL;
		
	END IF;

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='encryptedReferenceId')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `encryptedReferenceId` varchar(100) NULL DEFAULT NULL;
		
	END IF;

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='referenceLinkStatus')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `referenceLinkStatus` varchar(100) NULL DEFAULT NULL;
		
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_references' AND column_name='referenceOrder')) THEN 
		
		ALTER TABLE `application_references` 
		ADD COLUMN `referenceOrder` INT(2) NOT NULL DEFAULT 0;
		
	END IF;

END $$

CALL V202001301433__Alter_ApplicationReference() $$

DROP PROCEDURE IF EXISTS V202001301433__Alter_ApplicationReference $$

DELIMITER ;