DROP PROCEDURE IF EXISTS student_publish_data;
DELIMITER $$
CREATE DEFINER=`ss_root`@`%` PROCEDURE `student_publish_data`(IN instudentId BIGINT(20), IN firstResult INT(11), IN maxResult INT(11))
BEGIN

START TRANSACTION;
if firstResult is null then set firstResult = 0; end if;
if maxResult is null then set maxResult = 1000; end if;

BLOCK1: BEGIN
-- Hall ticket data
	SELECT
        FUNC_INC_VAR_SESSION() AS id,
        hallTicket.admissionId AS admissionId,
        admission.studentId AS studentId,
        hallTicket.reportType AS reportType,
        if(student_finance_hold.status='ACTIVE','',hallTicket.hallTicketPath) AS documentPath,
        if(student_finance_hold.status='ACTIVE','',hallTicket.hallTicketNumber) AS documentName,
        DATE_FORMAT(hallTicket.lastUpdate,'%Y-%m-%d') AS publishDate,
        batch.printName AS batchName,
        programs.programNameToBePrint AS programName,
        period.printName as periodName,
        "" as templateType
    FROM eval_group_hall_ticket as hallTicket
        JOIN admission ON hallTicket.admissionId = admission.id
        join prog_batch_period_config period on hallTicket.periodId=period.id
        join batches batch on period.programBatchId=batch.id
        join programs on batch.programId=programs.id
		left join student_finance_hold on admission.studentId=student_finance_hold.studentId
        and student_finance_hold.status='ACTIVE'
        left join finance_hold_criteria on student_finance_hold.financeHoldCriteriaId=finance_hold_criteria.id
         and finance_hold_criteria.holdType='HALL_TICKET_PUBLISH'
        and student_finance_hold.programBatchPeriodConfigId=hallTicket.periodId
WHERE
        hallTicket.isPublishHallTicket = true
            AND hallTicket.reportType = 'HALL_TICKET'
            AND admission.studentId= instudentId
           
-- Marksheet data
UNION SELECT
        FUNC_INC_VAR_SESSION() AS id,
        jobDetails.admissionId AS admissionId,
        admission.studentId AS studentId,
        'MARKSHEET' AS reportType,
        if(student_finance_hold.status='ACTIVE','',jobDetails.marksheetPath) AS documentPath,
        if(student_finance_hold.status='ACTIVE','',subLevel.marksheetJobSubLevelName) AS documentName,
        subLevel.publishDate AS publishDate,
        batches.printName AS batchName,
        programs.programNameToBePrint AS programName,
        prog_batch_period_config.printName as periodName,
		"" as templateType
	FROM marksheet_job_details as jobDetails
        JOIN marksheet_job_sub_level as subLevel ON jobDetails.marksheetJobSubLevelId = subLevel.id
        JOIN admission ON jobDetails.admissionId = admission.id
        left join marksheet_job on subLevel.marksheetJobId=marksheet_job.id
        left join batches on admission.batchId=batches.id
        left join programs on batches.programId=programs.id
        left join prog_batch_period_config on marksheet_job.periodId=prog_batch_period_config.id
        left join student_finance_hold on admission.studentId=student_finance_hold.studentId 
         and student_finance_hold.status='ACTIVE' 
         and marksheet_job.periodId=student_finance_hold.programBatchPeriodConfigId 
        left join finance_hold_criteria on student_finance_hold.financeHoldCriteriaId=finance_hold_criteria.id
        and finance_hold_criteria.holdType='RESULT_PUBLISH'
    WHERE
        jobDetails.isPublishMarksheet = true
        AND admission.studentId= instudentId
       
-- Evaluation Group marksheet data        
    UNION SELECT
        FUNC_INC_VAR_SESSION() AS id,
        details.admissionId AS admissionId,
        admission.studentId AS studentId,
        'MARKSHEET' AS reportType,
        details.marksheetPath AS documentPath,
        details.marksheetPath AS documentName,
        details.publishDate AS publishDate,
        batches.printName AS batchName,
        programs.programNameToBePrint AS programName,
        prog_batch_period_config.printName as periodName,
        report_template.templateType as templateType
    FROM
        evaluation_group_marksheet as markSheet
        JOIN evaluation_group_marksheet_details as details ON markSheet.id = details.evaluationGroupMarksheetId
        join report_template_configuration config on config.id=markSheet.templateId
        join report_template on report_template.id=config.reportTemplateId
        JOIN admission ON details.admissionId = admission.id
        left join batches on admission.batchId=batches.id
        left join programs on batches.programId=programs.id
        left join prog_batch_period_config on admission.programBatchPeriodConfigId=prog_batch_period_config.id
    WHERE
        details.isPublishMarksheet = true
        AND admission.studentId= instudentId

-- Exam report document data        
    UNION SELECT
        FUNC_INC_VAR_SESSION() AS id,
        examDoc.admissionId AS admissionId,
        admission.studentId AS studentId,
        examDoc.reportType AS reportType,
        examDoc.documentPath AS documentPath,
        examDoc.documentName AS documentName,
        examDoc.publishDate AS publishDate,
        batches.printName AS batchName,
        programs.programNameToBePrint AS programName,
        prog_batch_period_config.printName as periodName,
		"" as templateType
    FROM
        examination_report_document as examDoc
        JOIN admission ON examDoc.admissionId = admission.id
        left join batches on admission.batchId=batches.id
        left join programs on batches.programId=programs.id
        left join prog_batch_period_config on admission.programBatchPeriodConfigId=prog_batch_period_config.id
    WHERE
        examDoc.isPublish = true
        AND admission.studentId= instudentId
		group by reportType,levelName
		HAVING   COUNT(DISTINCT publishDate)
		order by documentPath desc
        LIMIT firstResult, maxResult;
 END BLOCK1;


COMMIT;    
END$$
DELIMITER ;
