DELIMITER $$
DROP PROCEDURE IF EXISTS V20200224181916__Create_mapCourseProgramOutComesTable $$
CREATE PROCEDURE V20200224181916__Create_mapCourseProgramOutComesTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='map_course_program_outcomes')) THEN 
CREATE TABLE `map_course_program_outcomes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `periodId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `manageProgramOutComesId` bigint(20) NOT NULL,
  `obeCorrelationId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_map_course_program_outcomes_period_idx` (`periodId`),
  KEY `fk_map_course_program_outcomes_course_idx` (`courseId`),
  KEY `fk_map_course_program_outcomes_program_outcome_idx` (`manageProgramOutComesId`),
  KEY `fk_map_course_program_outcomes_obe_correlation_idx` (`obeCorrelationId`),
  KEY `fk_map_course_program_outcomes_users_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_map_course_program_outcomes_course` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_program_outcomes_obe_correlation` FOREIGN KEY (`obeCorrelationId`) REFERENCES `obe_correlation_level` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_program_outcomes_period` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_program_outcomes_program_outcome` FOREIGN KEY (`manageProgramOutComesId`) REFERENCES `manage_program_outcomes` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_map_course_program_outcomes_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20200224181916__Create_mapCourseProgramOutComesTable () $$ 
DROP PROCEDURE IF EXISTS V20200224181916__Create_mapCourseProgramOutComesTable $$ 
DELIMITER ;