DELIMITER $$
DROP PROCEDURE IF EXISTS V20200224184032__Create_managecourseoutcomesTable $$
CREATE PROCEDURE V20200224184032__Create_managecourseoutcomesTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_course_outcomes')) THEN 
CREATE TABLE `manage_course_outcomes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseId` bigint(20) NOT NULL,
  `courseOutComeCode` varchar(255) NOT NULL,
  `description` varchar(550) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_key` (`courseId`,`courseOutComeCode`),
  KEY `fk_manage_course_outcomes_course_idx` (`courseId`),
  KEY `fk_manage_course_outcomes_users_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_manage_course_outcomes_course` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_course_outcomes_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20200224184032__Create_managecourseoutcomesTable () $$ 
DROP PROCEDURE IF EXISTS V20200224184032__Create_managecourseoutcomesTable $$ 
DELIMITER ;