DELIMITER $$
DROP PROCEDURE IF EXISTS V20200226192003__Create_GroupHomeWorkAssignmentAssessment $$
CREATE PROCEDURE V20200226192003__Create_GroupHomeWorkAssignmentAssessment()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='group_hw_assignment_assessment')) THEN 
CREATE TABLE `group_hw_assignment_assessment` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `groupHomeworkAssignmentId` BIGINT(20) NOT NULL,
  `examinationResultId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_group_hw_assignment_1_idx` (`groupHomeworkAssignmentId` ASC),
  INDEX `fk_examination_result_Id_idx` (`examinationResultId` ASC),
  CONSTRAINT `fk_group_hw_assignment`
    FOREIGN KEY (`groupHomeworkAssignmentId`)
    REFERENCES `group_hw_assignment` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_examination_result_Id`
    FOREIGN KEY (`examinationResultId`)
    REFERENCES `examination_result` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200226192003__Create_GroupHomeWorkAssignmentAssessment () $$ 
DROP PROCEDURE IF EXISTS V20200226192003__Create_GroupHomeWorkAssignmentAssessment $$ 
DELIMITER ;