DELIMITER $$
DROP PROCEDURE IF EXISTS V20200316130806__Create_application_reviewer_detail $$
CREATE PROCEDURE V20200316130806__Create_application_reviewer_detail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_reviewer_detail')) THEN 
CREATE TABLE `application_reviewer_detail` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,	 
	  `applicationReviewerId` bigint(20) DEFAULT NULL,
	  `isWillingSuperwise` bit(1) NOT NULL DEFAULT b'0',
	  `reviewParameterId` bigint(20) DEFAULT NULL,
	  `reviewRatingId` bigint(20) DEFAULT NULL,
	  `reviewRemarks` varchar(255) DEFAULT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	   `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
	   PRIMARY KEY (`id`),	
	   CONSTRAINT `fk_application_reviewerId` FOREIGN KEY (`applicationReviewerId`) REFERENCES `application_reviewer` (`id`),
	   CONSTRAINT `fk_application_reviewParameterId` FOREIGN KEY (`reviewParameterId`) REFERENCES `review_parameter` (`id`),
	   CONSTRAINT `fk_application_reviewRatingId` FOREIGN KEY (`reviewRatingId`) REFERENCES `review_parameter_rating` (`id`),
	   CONSTRAINT `fk_application_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
	  );
END IF; 

END $$
CALL V20200316130806__Create_application_reviewer_detail () $$ 
DROP PROCEDURE IF EXISTS V20200316130806__Create_application_reviewer_detail $$ 
DELIMITER ;