DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402144249__Create_student_course_attendance_view $$
CREATE PROCEDURE V20200402144249__Create_student_course_attendance_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'student_course_attendance_view')) THEN 
DROP view `student_course_attendance_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'student_course_attendance_view')) THEN 
   
CREATE OR REPLACE VIEW `student_course_attendance_view` AS
select 
        `al`.`academyName` AS `Academy`,
        `al`.`locationName` AS `Location`,
        `al`.`id` AS `Academy Location Id`,
        `pg`.`groupName` AS `ProgramGroup`,
        `prg`.`programName` AS `ProgramName`,
        `bch`.`batchName` AS `Batch`,
        `iy`.`itemValue` AS `Intake`,
        `period`.`programPeriodName` AS `Period`,
        `at`.`itemValue` AS `AcademicTerm`,
        `dept`.`deptName` AS `Department`,
        `cou`.`courseCode` AS `courseCode`,
        `cou`.`courseName` AS `courseName`,
        `cg`.`categoryName` AS `CourseCategory`,
        `cv`.`courseVariantCode` AS `courseVariantCode`,
        `fac`.`printName` AS `Faculty`,
        `usr`.`code` AS `studentCode`,
        `adm`.`code` AS `admissionCode`,
        `usr`.`printName` AS `studentName`,
        `sca`.`dateOfAttendance` AS `attendanceDate`,
        `sca`.`fromTime` AS `fromTime`,
        `sca`.`toTime` AS `toTime`,
        `amt`.`itemValue` AS `AttendanceStatus`,
        `scad`.`attendanceStatus` AS `attenStatus`,
        `period`.`id` AS `periodId`,
        `adm`.`id` AS `admissionId`,
        `cv`.`id` AS `courseVariantId`
    from
        ((((((((((((((((((`student_course_attendance_details` `scad`
        join `attendance_marking_type` `amt` ON ((`amt`.`id` = `scad`.`attendanceMarkingTypeId`)))
        join `student_course_attendance` `sca` ON ((`sca`.`id` = `scad`.`attendanceId`)))
        join `admission` `adm` ON ((`adm`.`id` = `scad`.`admissionId`)))
        join `course_variants` `cv` ON ((`cv`.`id` = `sca`.`variantId`)))
        join `student_course_enrollment` `sce` ON (((`sce`.`courseVarientId` = `sca`.`variantId`)
            and (`sce`.`admissionId` = `scad`.`admissionId`))))
        join `prog_batch_period_config` `period` ON ((`sce`.`programBatchPeriodConfigId` = `period`.`id`)))
        join `batches` `bch` ON ((`bch`.`id` = `period`.`programBatchId`)))
        join `intake_year` `iy` ON ((`iy`.`id` = `bch`.`intakeYearId`)))
        join `academic_term` `at` ON ((`at`.`id` = `period`.`academicTermId`)))
        join `programs` `prg` ON ((`prg`.`id` = `bch`.`programId`)))
        join `academy_location` `al` ON ((`al`.`id` = `prg`.`academyLocationId`)))
        join `program_group` `pg` ON ((`pg`.`id` = `prg`.`programGroupId`)))
        join `sections` `sec` ON ((`sec`.`id` = `sca`.`sectionId`)))
        join `courses` `cou` ON ((`cou`.`id` = `cv`.`courseId`)))
        join `department` `dept` ON ((`dept`.`id` = `cou`.`departmentId`)))
        left join `course_category` `cg` ON ((`cg`.`id` = `cou`.`courseCategoryId`)))
        join `users` `usr` ON ((`usr`.`id` = `adm`.`studentId`)))
        join `users` `fac` ON ((`fac`.`id` = `sca`.`facultyId`)))
 where
        (`sca`.`dateOfAttendance` >= (now() - interval 3 month))

    group by `adm`.`id` , `period`.`id` , `sca`.`variantId` , `sca`.`id`;
END IF; 

END $$
CALL V20200402144249__Create_student_course_attendance_view () $$ 
DROP PROCEDURE IF EXISTS V20200402144249__Create_student_course_attendance_view $$ 
DELIMITER ;