DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402144716__Create_pending_attendance_view $$
CREATE PROCEDURE V20200402144716__Create_pending_attendance_view()
BEGIN
IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'pending_attendance_view')) THEN 
DROP view `pending_attendance_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'pending_attendance_view')) THEN 
   
CREATE OR REPLACE VIEW `pending_attendance_view` AS  
Select 
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `loc`.`id` AS `LOCATION_ID`,
        `loc`.`locationName` AS `LOCATION_NAME`,
        `ad`.`academyName` AS `ACADEMY_NAME`,
        `pgrm`.`programName` AS `programName`,
        `pgrm`.`id` AS `PROGRAM_ID`,
        `b`.`batchName` AS `batchName`,
        `pbp`.`programPeriodName` AS `programPeriodName`,
        `s`.`sectionCode` AS `sectionCode`,
        `pbp`.`programPeriodStart` AS `programPeriodStart`,
        `pbp`.`programPeriodEnd` AS `programPeriodEnd`,
        `td`.`trans_date` AS `trans_date`,
        `td`.`day_name` AS `day_name`,
        `prsn`.`printName` AS `facultyName`,
        `pgrm`.`programSequence` AS `programSequence`,
        `s`.`id` AS `SectionId`,
        `pgrm_cat`.`categoryName` AS `programCategory`
    from
        ((((((((((((((`sections` `s`
        join `prog_batch_period_config` `pbp` ON (((`s`.`periodId` = `pbp`.`id`)
            and (`pbp`.`isCurrentPeriodOfProgram` = 1))))
        join `batches` `b` ON ((`b`.`id` = `pbp`.`programBatchId`)))
        join `programs` `pgrm` ON ((`pgrm`.`id` = `b`.`programId`)))
        join `program_category` `pgrm_cat` ON ((`pgrm_cat`.`id` = `pgrm`.`programCategoryId`)))
        join `academy_location` `al` ON ((`al`.`id` = `pgrm`.`academyLocationId`)))
        join `academies` `ad` ON ((`ad`.`id` = `al`.`academyId`)))
        join `locations` `loc` ON ((`loc`.`id` = `al`.`locationId`)))
        join `staffs` `st` ON ((`st`.`userId` = `s`.`facultyId`)))
        join `persons` `prsn` ON ((`prsn`.`id` = `st`.`personId`)))
        join `time_dimension` `td` ON (((`td`.`trans_date` between `pbp`.`programPeriodStart` and `pbp`.`programPeriodEnd`)
            and (`td`.`trans_date` <= curdate())
            and (`pbp`.`programPeriodEnd` >= curdate()))))
        join `calendar_working_weekdays` `cww` ON ((`cww`.`calendarId` = `b`.`calendarId`)))
        join `calendar_weekdays` `cw` ON (((`cww`.`calendarWeekdayId` = `cw`.`id`)
            and (`cw`.`weekDay` = `td`.`day_name`))))
        left join `student_program_attendance` `spa` ON (((`s`.`id` = `spa`.`sectionId`)
            and (`s`.`facultyId` = `spa`.`facultyId`)
            and (`spa`.`dateOfAttendance` = `td`.`trans_date`)
            and (`spa`.`attendanceType` = 'COMPLETE_DAY'))))
        left join `pending_attendance_time_dimension_view` `cal_holi` ON (((`td`.`trans_date` = `cal_holi`.`trans_date`)
            and (`cal_holi`.`calendarId` = `b`.`calendarId`))))
    where
        (isnull(`spa`.`id`)
            and isnull(`cal_holi`.`trans_date`)
            and (`td`.`trans_date` >= (now() - interval 3 month)));
END IF; 

END $$
CALL V20200402144716__Create_pending_attendance_view () $$ 
DROP PROCEDURE IF EXISTS V20200402144716__Create_pending_attendance_view $$ 
DELIMITER ;