DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402165344__Create_fet_phase_result_view $$
CREATE PROCEDURE V20200402165344__Create_fet_phase_result_view()
BEGIN

	IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
		   WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'FET_Phase_Result_View')) THEN 
	DROP view `FET_Phase_Result_View`;
	END IF; 


	IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
		   WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'fet_phase_result_view')) THEN 
CREATE or REPLACE VIEW `fet_phase_result_view` AS
     select distinct
        `al`.`academyName` AS `Brand`,
        `al`.`locationName` AS `Campus`,
        `al`.`displayName` AS `Brand Campus`,
        `al`.`id` AS `Academy Location Id`,
        `pg`.`groupName` AS `School Phase`,
        `result`.`programName` AS `Grade`,
        `pc`.`categoryName` AS `Grade Category`,
        `result`.`batchName` AS `Intake`,
        `result`.`periodName` AS `Period`,
        `result`.`stdName` AS `Student Name`,
        `usr`.`code` AS `Student Id`,
        `result`.`courseName` AS `Subject`,
        `result`.`courseVariant` AS `Subject Variant`,
        `cc`.`categoryName` AS `Subject Category`,
        `fac`.`printName` AS `Teacher`,
        `result`.`planPrintName` AS `Scheme`,
        `result`.`maxMarksOrGrade` AS `Maximum Marks`,
        `result`.`effectiveMarks` AS `Subject Level Marks`,
        `result`.`grade` AS `Subject Grade`,
        `result`.`effectiveMarks` AS `Percentage`,
        `result`.`status` AS `Result Status`,
        `result`.`levelOnePrintName` AS `Type`,
        `result`.`effectiveMarks` AS `Type Marks`,
        `result`.`grade` AS `Type Grade`,
        `result`.`status` AS `Type Result Status`,
        `result`.`levelTwoPrintName` AS `SubType`,
        `result`.`effectiveMarks` AS `SubType Marks`,
        `result`.`grade` AS `SubType Grade`,
        `result`.`status` AS `SubType Result Status`
    from
        (((((((((((((`marksheet` `result`
        join `admission` ON (((`admission`.`id` = `result`.`admissionId`)
            and isnull(`result`.`evaluationPlanThreeId`)
            and (`result`.`courseVariantId` is not null))))
        join `users` `usr` ON ((`usr`.`id` = `result`.`studentId`)))
        join `academy_location` `al` ON ((`al`.`id` = `admission`.`academyLocationId`)))
        join `programs` `prgm` ON (((`prgm`.`id` = `result`.`programId`)
            and (`prgm`.`programPhaseId` = 4))))
        join `program_group` `pg` ON ((`pg`.`id` = `prgm`.`programGroupId`)))
        join `program_category` `pc` ON ((`pc`.`id` = `prgm`.`programCategoryId`)))
        join `prog_batch_period_config` `period` ON ((`period`.`id` = `result`.`periodId`)))
        join `academic_term` `term` ON ((`term`.`id` = `period`.`academicTermId`)))
        left join `courses` `course` ON ((`course`.`id` = `result`.`courseId`)))
        left join `course_category` `cc` ON ((`cc`.`id` = `course`.`courseCategoryId`)))
        left join `program_batch_course_param` `param` ON (((`result`.`courseVariantId` = `param`.`courseVarientId`)
            and (`result`.`periodId` = `param`.`progBatchPeriodConfigId`))))
        left join `prog_batch_course_faculty` `pbcf` ON ((`pbcf`.`progBatchCourseParamId` = `param`.`id`)))
        left join `users` `fac` ON ((`fac`.`id` = `pbcf`.`facultyId`)))
    where
        ((`result`.`courseVariantId` is not null)
            and isnull(`result`.`evaluationPlanThreeId`)
            and (`prgm`.`programPhaseId` = 4));
END IF; 

END $$
CALL V20200402165344__Create_fet_phase_result_view () $$ 
DROP PROCEDURE IF EXISTS V20200402165344__Create_fet_phase_result_view $$ 
DELIMITER ;