DELIMITER $$
DROP PROCEDURE IF EXISTS V20200323183803__Insert_TabulationRegister $$
CREATE PROCEDURE V20200323183803__Insert_TabulationRegister()
BEGIN

IF NOT EXISTS (SELECT * FROM `report_template` WHERE `templateCode` = 'RGI_TABULATION_REGISTER_NAGPUR') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) VALUES 
('14', 'RGI_TABULATION_REGISTER_NAGPUR', 'RGI Tabulation Report - Nagpur', 'RGI_TABULATION_REGISTER_NAGPUR.png', 'CommonReport_LandScape_Without_Footer.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'RGI_TABULATION_REGISTER_NAGPUR.jasper', 'AcademiaLogo.png');

END IF; 

IF NOT EXISTS (select * from ui_translation where ui_translation.objectName='EXAMINATION' and keyName='RGI_TABULATION_REGISTER_NAGPUR') THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ( 'EXAMINATION', 'RGI_TABULATION_REGISTER_NAGPUR', 'RGI Tabulation Report - Nagpur', now(), '1');
END IF;

IF EXISTS (select * from `report_template` where `templateCode` = 'RGI_TABULATION_REGISTER') THEN 
SET SQL_SAFE_UPDATES=0;
UPDATE `report_template` SET `templateName`='RGI Tabulation Report - Amravati' WHERE templateCode = 'RGI_TABULATION_REGISTER';
SET SQL_SAFE_UPDATES=1;
END IF;

IF EXISTS (select * from ui_translation where ui_translation.objectName='EXAMINATION' and keyName='RGI_TABULATION_REGISTER') THEN 
SET SQL_SAFE_UPDATES=0;
UPDATE `ui_translation` SET `defaultValue`='RGI Tabulation Report - Amravati' WHERE ui_translation.objectName='EXAMINATION' and keyName='RGI_TABULATION_REGISTER';
SET SQL_SAFE_UPDATES=1;
END IF;

END $$

CALL V20200323183803__Insert_TabulationRegister() $$
DROP PROCEDURE IF EXISTS V20200323183803__Insert_TabulationRegister $$
DELIMITER ;