DELIMITER $$
DROP PROCEDURE IF EXISTS V20200519144240__Insert_DataGridApplicantConsolidatedReport $$
CREATE PROCEDURE V20200519144240__Insert_DataGridApplicantConsolidatedReport()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName="Academia.view.feeandpayment.reports.ApplicantFeeReportGrid" and portalId = 1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
	('Academia.view.feeandpayment.reports.ApplicantFeeReportGrid',1 ,
	'[{"id":null,"columnName":"APPLICANT_ID","dataIndex":"printName","columnVisibility":"SHOW","sequence":1,"mandatory": true},
	{"id":null,"columnName":"APPLICANT_NAME","dataIndex":"studentCount","columnVisibility":"SHOW","sequence":2,"mandatory": true},
	{"id":null,"columnName":"FATHER_NAME","dataIndex":"fatherName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
	{"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
	{"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":5,"mandatory":false},
    {"id":null,"columnName":"SEAT_TYPE","dataIndex":"seatName","columnVisibility":"HIDE","sequence":6,"mandatory":false},
    {"id":null,"columnName":"TOTAL_AMOUNT","dataIndex":"feeAmount","columnVisibility":"HIDE","sequence":7,"mandatory":false},
    {"id":null,"columnName":"DISCOUNT_AMOUNT","dataIndex":"discountAmount","columnVisibility":"HIDE","sequence":8,"mandatory":false},
    {"id":null,"columnName":"TOTAL_BILL","dataIndex":"totalBillAmount","columnVisibility":"SHOW","sequence":9,"mandatory":false},
    {"id":null,"columnName":"TOTAL_RECEIPT_AMOUNT_SETTLED","dataIndex":"totalNetCollectionAmount","columnVisibility":"SHOW","sequence":10,"mandatory":false},
    {"id":null,"columnName":"TOTAL_OUTSTANDING","dataIndex":"totalOutstandingAmount","columnVisibility":"SHOW","sequence":11,"mandatory":false},
    {"id":null,"columnName":"TOTAL_PAYMENT","dataIndex":"totalPaymentAmount","columnVisibility":"SHOW","sequence":12,"mandatory":false},
    {"id":null,"columnName":"NET_OUTSTANDING_AMOUNT","dataIndex":"netOutStandingAmount","columnVisibility":"SHOW","sequence":13,"mandatory":false},
    {"id":null,"columnName":"ADDRESS","dataIndex":"address","columnVisibility":"HIDE","sequence":14,"mandatory":false},
    {"id":null,"columnName":"EMAIL_ID","dataIndex":"emailId","columnVisibility":"HIDE","sequence":15,"mandatory":false},
    {"id":null,"columnName":"MOBILE_NUMBER","dataIndex":"mobileNo","columnVisibility":"HIDE","sequence":16,"mandatory":false},
    {"id":null,"columnName":"FIRST_NAME","dataIndex":"personFirstName","columnVisibility":"HIDE","sequence":17,"mandatory":false},
    {"id":null,"columnName":"MIDDLE_NAME","dataIndex":"personMiddleName","columnVisibility":"HIDE","sequence":18,"mandatory":false},
    {"id":null,"columnName":"LAST_NAME","dataIndex":"personLastName","columnVisibility":"HIDE","sequence":19,"mandatory":false}]',now(),1);
END IF; 

END $$
CALL V20200519144240__Insert_DataGridApplicantConsolidatedReport() $$
DROP PROCEDURE IF EXISTS V20200519144240__Insert_DataGridApplicantConsolidatedReport $$
DELIMITER ;