DELIMITER $$
DROP PROCEDURE IF EXISTS V20200520163057__Alter_coursesTable $$
CREATE PROCEDURE V20200520163057__Alter_coursesTable()
BEGIN

ALTER TABLE `courses` CHANGE COLUMN `lastUpdate` `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ;

IF EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='courses')) THEN 
ALTER TABLE `courses` 
ADD COLUMN `courseNameLanguageOne` VARCHAR(255) NULL DEFAULT NULL AFTER `calculationRule`,
ADD COLUMN `courseShortNameLanguageOne` VARCHAR(255) NULL DEFAULT NULL AFTER `courseNameLanguageOne`,
ADD COLUMN `courseNameLanguageTwo` VARCHAR(255) NULL DEFAULT NULL AFTER `courseShortNameLanguageOne`,
ADD COLUMN `courseShortNameLanguageTwo` VARCHAR(255) NULL DEFAULT NULL AFTER `courseNameLanguageTwo`,
ADD COLUMN `courseNameLanguageThree` VARCHAR(255) NULL DEFAULT NULL AFTER `courseShortNameLanguageTwo`,
ADD COLUMN `courseShortNameLanguageThree` VARCHAR(255) NULL DEFAULT NULL AFTER `courseNameLanguageThree`,
ADD COLUMN `courseCESMCode` VARCHAR(255) NULL DEFAULT NULL AFTER `courseShortNameLanguageThree`,
ADD COLUMN `courseNQFLevel` VARCHAR(255) NULL DEFAULT NULL AFTER `courseCESMCode`,
ADD COLUMN `isLMSCourses` BIT(1) NOT NULL DEFAULT b'0' AFTER `courseNQFLevel`,
ADD COLUMN `lMSCourseOfferYear` VARCHAR(45) NULL DEFAULT NULL AFTER `isLMSCourses`,
ADD COLUMN `isPublishToLMS` BIT(1) NOT NULL DEFAULT b'0' AFTER `lMSCourseOfferYear`;
END IF; 

END $$
CALL V20200520163057__Alter_coursesTable() $$
DROP PROCEDURE IF EXISTS V20200520163057__Alter_coursesTable $$
DELIMITER ;