DELIMITER $$
DROP PROCEDURE IF EXISTS V20200608202025__Alter_CourseTableForCourseCESMId $$
CREATE PROCEDURE V20200608202025__Alter_CourseTableForCourseCESMId()
BEGIN

ALTER TABLE `courses` CHANGE COLUMN `lastUpdate` `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ;

IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='courses'    AND column_name='courseCESMCode')
THEN 
SET SQL_SAFE_UPDATES = 0;
UPDATE `courses` SET `courseCESMCode`=NULL ;
SET SQL_SAFE_UPDATES = 1;
END IF; 


IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='courses' AND column_name='courseCESMCode'))  THEN 
ALTER TABLE `courses` 
CHANGE COLUMN `courseCESMCode` `courseCESMCodeId` BIGINT(20) NULL DEFAULT NULL ;


ALTER TABLE `courses` 
ADD INDEX `fk_courses_2_idx` (`courseCESMCodeId` ASC);
ALTER TABLE `courses` 
ADD CONSTRAINT `fk_courses_2`
  FOREIGN KEY (`courseCESMCodeId`)
  REFERENCES `course_cesm_code` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


END IF; 

END $$
CALL V20200608202025__Alter_CourseTableForCourseCESMId() $$
DROP PROCEDURE IF EXISTS V20200608202025__Alter_CourseTableForCourseCESMId $$
DELIMITER ;
