DELIMITER $$
DROP PROCEDURE IF EXISTS V20200618123032__Insert_ResultAnalysisReport $$
CREATE PROCEDURE V20200618123032__Insert_ResultAnalysisReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RESULT_ANALYSIS_REPORT')) 
THEN 

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES ('10', 'RESULT_ANALYSIS_REPORT', 'Result Analysis Report', 'RESULT_ANALYSIS_REPORT.png', 'Analysis_CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'RESULT_ANALYSIS_REPORT.jasper', 'AcademiaLogo.png'); 


set @resultAnalysis = (select max(id) from report_template where templateCode ='RESULT_ANALYSIS_REPORT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@resultAnalysis, 'TRANS_REPORT_NAME', 'RESULT ANALYSIS REPORT', '1', NOW()),
(@resultAnalysis, 'TRANS_DATE', 'Date :', '1', NOW()),
(@resultAnalysis, 'TRANS_SNO', 'Sr.No.', '1', NOW()),
(@resultAnalysis, 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@resultAnalysis, 'TRANS_BATCH_NAME', 'Batch Name', '1', NOW()),
(@resultAnalysis, 'TRANS_PERIOD_NAME', 'Period Name', '1', NOW()),
(@resultAnalysis, 'TRANS_COURSES_NUMBER', 'No. of Courses', '1', NOW()),
(@resultAnalysis, 'TRANS_STUDENTS_APPEARED_NUMBER','No. of Students Appeared', '1', NOW()),
(@resultAnalysis, 'TRANS_STUDENTS_ABSENT_NUMBER', 'No. of Students Absent', '1', NOW()),
(@resultAnalysis, 'TRANS_STUDENTS_PASSED_NUMBER', 'No. of Students Passed', '1', NOW()),
(@resultAnalysis, 'TRANS_STUDENTS_FAILED_NUMBER', 'No. of Students Failed', '1', NOW()),
(@resultAnalysis, 'TRANS_STUDENTS_PASSED_PERCENTAGE', 'Percentage of Students Passed', '1', NOW()),
(@resultAnalysis, 'TRANS_STUDENTS_FAILED_PERCENTAGE', 'Percentage of Students Failed', '1', NOW());
 

END IF; 

END $$
CALL V20200618123032__Insert_ResultAnalysisReport() $$
DROP PROCEDURE IF EXISTS V20200618123032__Insert_ResultAnalysisReport $$
DELIMITER ;
