DELIMITER $$

DROP PROCEDURE IF EXISTS V20200618133143__Insert_BankDrawnChildInCSM $$

CREATE PROCEDURE V20200618133143__Insert_BankDrawnChildInCSM()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='bank_drawn_child')) THEN 

		CREATE TABLE `bank_drawn_child` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`bankDrawnOnMasterId` BIGINT(20) NULL,
  		`itemCode` varchar(255) NOT NULL,
		`sequence` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_bank_drawn_child_id_idx` (`bankDrawnOnMasterId` ASC),
		INDEX `fk_bank_drawn_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_bank_drawn_child_id_idx`
		    FOREIGN KEY (`bankDrawnOnMasterId`)
		    REFERENCES `bank_drawn_on_master` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_bank_drawn_child_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'bank_drawn_child')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'bank_drawn_child','BANK_DRAWN_CHILD','Admissions','COMMON_MASTER',1,0,1,SYSDATE());
		
		SET FOREIGN_KEY_CHECKS=0;
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='bank_drawn_child');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='bank_drawn_on_master';
		SET SQL_SAFE_UPDATES = 1;
		SET FOREIGN_KEY_CHECKS=1;
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'BRANCH_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'sequence', 'SEQUENCE_NO', @standardMasterMaxId+1, 'Number', '2', 0, 0, 0, 0, '1',SYSDATE());

	END IF; 

END $$

CALL V20200618133143__Insert_BankDrawnChildInCSM () $$

DROP PROCEDURE IF EXISTS V20200618133143__Insert_BankDrawnChildInCSM $$

DELIMITER ;